<?php


namespace GekTools\Tools\Templates;


use JsonSerializable;

class TemplateInfo implements JsonSerializable
{

    #region fields

    /**
     * @var string
     */
    protected string $name;

    /**
     * @var string
     */
    protected string $version;

    /**
     * @var string|null
     */
    protected ?string $areaName = null;

    #endregion fields

    #region ctor

    public function __construct(string $name = '', string $version = '')
    {
        $this->name = $name;
        $this->version = $version;
    }



    #endregion ctor

    #region properties

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return TemplateInfo
     */
    public function setName(string $name): TemplateInfo
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getVersion(): string
    {
        return $this->version;
    }

    /**
     * @param string $version
     * @return TemplateInfo
     */
    public function setVersion(string $version): TemplateInfo
    {
        $this->version = $version;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAreaName(): ?string
    {
        return $this->areaName;
    }

    /**
     * @param string|null $areaName
     * @return TemplateInfo
     */
    public function setAreaName(?string $areaName): TemplateInfo
    {
        $this->areaName = $areaName;
        return $this;
    }

    #endregion properties

    #region methods


    /**
     * @return string
     */
    public function toFormattedJson():string {
        return json_encode($this,JSON_PRETTY_PRINT);
    }

    #endregion methods

    #region JsonSerializable

    /**
     * Specify data which should be serialized to JSON
     * @link https://php.net/manual/en/jsonserializable.jsonserialize.php
     * @return mixed data which can be serialized by <b>json_encode</b>,
     * which is a value of any type other than a resource.
     * @since 5.4.0
     */
    public function jsonSerialize()
    {
        $res = [
            'name' => $this->name,
            'version' => $this->version,
        ];
        if($this->getAreaName() !== null){
            $res['areaName'] = $this->areaName;
        }
        return (object) $res;
    }

    #endregion JsonSerializable

    #region statics

    /**
     * @param string $json
     * @return TemplateInfo
     */
    public static function fromJsonString(string $json):self {
        $obj = json_decode($json);
        $res = new static();
        if(isset($obj->name)){
            $res->setName($obj->name);
        }
        if(isset($obj->version)){
            $res->setVersion($obj->version);
        }
        if(isset($obj->areaName)){
            $res->setAreaName($obj->areaName);
        }
        return $res;
    }

    #endregion statics
}