<?php


namespace GekTools\Tools\Html;


class TextNode extends HtmlNode
{

    #region fields

    /**
     * @var string
     */
    protected string $text;



    #endregion fields

    #region ctor

    public function __construct(string $text = '')
    {
        parent::__construct();
        $this->text = $text;
    }

    #endregion ctor

    #region Properties

    /**
     * @return string
     */
    public function getText(): string
    {
        return $this->text;
    }

    /**
     * @param string $text
     * @return TextNode
     */
    public function setText(string $text): TextNode
    {
        $this->text = $text;
        return $this;
    }

    #endregion Properties

    #region methods

    /**
     * @return string
     */
    public function toHtmlString(): string
    {
        return $this->text;
    }

    #endregion methods


}