<?php
namespace GekTools\Membership\Entities;

use GekTools\Tools\BaseEntity;
use GekTools\Membership\Entities\Extensions\PermissionRoleMapTrait;

class PermissionRoleMap extends BaseEntity 
{

    use PermissionRoleMapTrait;

    #region fields

    protected $attributes = [
        'id' => null,
        'permissionRecordId' => null,
        'userRoleId' => null,
    ];

    protected $defaultValues = [
        'id' => 0,
        'permissionRecordId' => 0,
        'userRoleId' => 0,
    ];

    protected $datamap = [];

    protected $casts = [
        'id' => 'int',
        'permissionRecordId' => 'int',
        'userRoleId' => 'int',
    ];

    #endregion fields

    #region properties

    /**
     * id getter

     * 
     * @return int|null
     * @throws \Exception
     */ 
    public function getId():?int {
        $_attrKey = $this->mapProperty('id');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'int');
        return $result;
    }

    /**
     * permissionRecordId getter

     * 
     * @return int|null
     * @throws \Exception
     */ 
    public function getPermissionRecordId():?int {
        $_attrKey = $this->mapProperty('permissionRecordId');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'int');
        return $result;
    }

    /**
     * permissionRecordId setter

     * 
     * @param int $permissionRecordId
     * @return self
     */ 
    public function setPermissionRecordId(int $permissionRecordId):self {
        $_attrKey = $this->mapProperty('permissionRecordId');
        $this->attributes[$_attrKey] = $permissionRecordId;
        return $this;
    }

    /**
     * userRoleId getter

     * 
     * @return int|null
     * @throws \Exception
     */ 
    public function getUserRoleId():?int {
        $_attrKey = $this->mapProperty('userRoleId');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'int');
        return $result;
    }

    /**
     * userRoleId setter

     * 
     * @param int $userRoleId
     * @return self
     */ 
    public function setUserRoleId(int $userRoleId):self {
        $_attrKey = $this->mapProperty('userRoleId');
        $this->attributes[$_attrKey] = $userRoleId;
        return $this;
    }

    #endregion properties

    #region statics

    /**
     * get db Fields info

     * 
     * @return PermissionRoleMapFieldsInfo
     */ 
    public static function getFieldsInfo():PermissionRoleMapFieldsInfo {
        static $fInfo = null;
        if($fInfo == null){
            $fInfo = new PermissionRoleMapFieldsInfo();
        }
        return $fInfo;
    }

    #endregion statics

}


class PermissionRoleMapFieldsInfo 
{

    /**
     * 
     * @var string
     */ 
    public string $id = 'id';

    /**
     * 
     * @var string
     */ 
    public string $permissionRecordId = 'permissionRecordId';

    /**
     * 
     * @var string
     */ 
    public string $userRoleId = 'userRoleId';

}
