<?php 

namespace GekTools\Membership\Database\Migrations;

use CodeIgniter\Database\Migration;
use GekTools\Tools\Traits\MigrationTrait;

class CreatePermissionRecords extends Migration 
{

    use MigrationTrait;

    protected string $tableName = 'permission_records';

    protected string $pkName = 'id';

    public function up(){
        $this->entityName = 'PermissionRecord';
        $this->namespace = 'GekTools\\Membership';
        $this->addPrimaryKeyField($this->pkName);

        $this->addStringField('name',1000)
            ->addSystemNameField()
            ->addStringField('category',255);

        $this->createTable($this->tableName);
    }

    public function down(){
        $this->forge->dropTable($this->tableName);
    }

}
