<?php


namespace GekTools\Commands;


use CodeIgniter\CLI\BaseCommand;
use CodeIgniter\CLI\CLI;
use CodeIgniter\Config\BaseConfig;
use CodeIgniter\Config\Config;
use Config\Services;

class RunMigrate  extends BaseCommand
{
    /**
     * The group the command is lumped under
     * when listing commands.
     *
     * @var string
     */
    protected $group = 'Ci4Tools';

    /**
     * The Command's name
     *
     * @var string
     */
    protected $name = 'run:migrate';

    /**
     * the Command's short description
     *
     * @var string
     */
    protected $description = 'Locates and runs all new migrations against the database.';

    /**
     * the Command's usage
     *
     * @var string
     */
    protected $usage = 'run:migrate [options]';

    /**
     * the Command's Arguments
     *
     * @var array
     */
    protected $arguments = [];

    /**
     * the Command's Options
     *
     * @var array
     */
    protected $options = [
        '-n'   => 'Set migration namespace',
        '-g'   => 'Set database group',
        '-all' => 'Set for all namespaces, will ignore (-n) option',
    ];

    /**
     * Ensures that all migrations have been run.
     *
     * @param array $params
     */
    public function run(array $params = [])
    {


        CLI::write(lang('Migrations.latest'), 'yellow');

        $namespace = $params['-n'] ?? CLI::getOption('n');
        $group     = $params['-g'] ?? CLI::getOption('g');

        try
        {
            // Check for 'all' namespaces
            if ($this->isAllNamespace($params))
            {

                $messages = array();
                $namespaces = \CodeIgniter\Config\Services::autoloader()->getNamespace();

                foreach ($namespaces as $nspc => $path) {

                    if($nspc == 'Tests\Support'){
                        continue;
                    }
                   // CLI::write($nspc);

                    $runner = \CodeIgniter\Config\Services::migrations();
                    $runner->clearCliMessages();
                    $runner->setNamespace($nspc);
                   try{
                       if (! $runner->latest($group))
                       {
                           CLI::write(lang('Migrations.generalFault'), 'red');
                       }
                   }catch (\Throwable $exp){
                       CLI::write($nspc . ' ' . $exp->getMessage(), 'red');
                   }
                    $messages = array_merge($messages,$runner->getCliMessages());
                }

            }
            // Check for a specified namespace
            elseif ($namespace)
            {
                $runner = \CodeIgniter\Config\Services::migrations();
                $runner->clearCliMessages();
                $runner->setNamespace($namespace);
                if (! $runner->latest($group))
                {
                    CLI::write(lang('Migrations.generalFault'), 'red');
                }
                $messages = $runner->getCliMessages();
            }else{
                $runner = \CodeIgniter\Config\Services::migrations();
                $runner->clearCliMessages();
                if (! $runner->latest($group))
                {
                    CLI::write(lang('Migrations.generalFault'), 'red');
                }
                $messages = $runner->getCliMessages();
            }




            foreach ($messages as $message)
            {
                CLI::write($message);
            }

            CLI::write('Done');
        }
        catch (\Exception $e)
        {
            $this->showError($e);
        }
    }

    /**
     * To migrate all namespaces to the latest migration
     *
     * Demo:
     *  1. command line: php spark migrate:latest -all
     *  2. command file: $this->call('migrate:latest', ['-g' => 'test','-all']);
     *
     * @param  array $params
     * @return boolean
     */
    private function isAllNamespace(array $params): bool
    {
        if (array_search('-all', $params) !== false)
        {
            return true;
        }

        return ! is_null(CLI::getOption('all'));
    }

}

