<?php


namespace GekTools\Commands;


use CodeIgniter\CLI\BaseCommand;
use CodeIgniter\CLI\CLI;
use CodeIgniter\Config\BaseService;
use Config\Services;
use Gek\Filesystem\Filesystem;
use Gek\PhpLang\CodeFactory;
use Gek\PhpLang\CodeLine;
use Gek\PhpLang\LiteralTypes;

class CreateCommand   extends BaseCommand
{

    protected $group = 'Ci4Tools';
    protected $name = 'create:command';
    protected $description = 'Command sınıfı oluşturur.';

    /**
     * the Command's usage
     *
     * @var string
     */
    protected $usage = 'create:command [command_name] [Options]';

    /**
     * the Command's Arguments
     *
     * @var array
     */
    protected $arguments = [
        'command_name' => 'Command adı'
    ];

    /**
     * the Command's Options
     *
     * @var array
     */
    protected $options = [
        '-n' => 'namespace ayarlar.',
    ];


    /**
     * Actually execute a command.
     * This has to be over-ridden in any concrete implementation.
     *
     * @param array $params
     * @throws \Throwable
     */
    public function run(array $params)
    {
        helper('inflector');

        $commandName = array_shift($params);
        if (empty($commandName)) {
            $commandName = CLI::prompt('Command adını girin');
        }
        $commandName = ucfirst($commandName);

        $ns = $params['-n'] ?? CLI::getOption('n');

        $homepath = APPPATH;

        if (!empty($ns)) {
            // Get all namespaces
            $namespaces = Services::autoloader()->getNamespace();

            foreach ($namespaces as $namespace => $path) {
                if ($namespace === $ns) {
                    $homepath = realpath(reset($path));
                    break;
                }
            }
        } else {
            $ns = 'App';
        }

        $commandNs = $ns . '\\Commands';
        $commandPath = $homepath . "/Commands/" .$commandName . '.php';
        $fs = new Filesystem();

        if ($fs->exists($commandPath)) {
            CLI::error('Dosya zaten mevcut : ' . str_replace($homepath, $ns, $commandPath));
            return;
        }


        $command = CodeFactory::classCreate($commandName)
            ->setNamespace($commandNs)
            ->setExtends(BaseCommand::class)
            ->addUse(CLI::class)
            ->addUse(Services::class);

        $groupField = $command->addField('group')
            ->setProtected()
            ->setValue('Ci4Tools',LiteralTypes::SINGLE_QUOTES);

        $cliName = $commandName;
        preg_match_all('/((?:^|[A-Z])[a-z]+)/',$cliName,$matches);
        $matches = $matches[0];
        if(count($matches) == 2){
            $cliName = implode(':',$matches);
        }elseif (count($matches) > 2){
            $first = array_shift($matches);
            $cliName = $first . ':' . implode('-',$matches);
        }
        $cliName = strtolower($cliName);

        $nameField = $command->addField('name')
            ->setProtected()
            ->setValue($cliName,LiteralTypes::SINGLE_QUOTES);

        $descriptionField = $command->addField('description')
            ->setProtected()
            ->setValue('Komut açıklaması.',LiteralTypes::SINGLE_QUOTES);

        $usageField = $command->addField('usage')
            ->setProtected()
            ->setValue($cliName . ' [argument_name] [Options]',LiteralTypes::SINGLE_QUOTES)
            ->addCommentTag('var','string')
            ->addCommentSummary('the Command\'s usage');
        $argVal = '['.PHP_EOL;
        $argVal .= (new CodeLine(' \'argument_name\' => \'Arguman açıklaması\',',2)) .PHP_EOL;
        $argVal .= (new CodeLine(']',1));

        $argumentsField = $command->addField('arguments')
            ->setProtected()
            ->setValue($argVal,LiteralTypes::NONE)
            ->addCommentTag('var','array')
            ->addCommentSummary('the Command\'s Arguments');

        $optVal = '['.PHP_EOL;
        $optVal .= (new CodeLine('\'-n\' => \'Namespace ayarlar.\',',2)) .PHP_EOL;
        $optVal .= (new CodeLine(']',1));

        $optionsField = $command->addField('options')
            ->setProtected()
            ->setValue($optVal,LiteralTypes::NONE)
            ->addCommentTag('var','array')
            ->addCommentSummary('the Command\'s Options');

        $runFn = $command->addMethod('run')
            ->setPublic()
            ->addParams('array $params')
            ->addCodeLine('$arg1 = array_shift($params);')
            ->addCodeLine('')
            ->addCodeLine('if (empty($arg1)) {')
            ->addCodeLine('$arg1 = CLI::prompt(\'arguman ı girin\');',1)
            ->addCodeLine('}')
            ->addCodeLine('')
            ->addCodeLine('$ns = $params[\'-n\'] ?? CLI::getOption(\'n\');')
            ->addCodeLine('$homepath = APPPATH;')
            ->addCodeLine('')
            ->addCodeLine('if (!empty($ns)) {')
            ->addCodeLine('// Get all namespaces',1)
            ->addCodeLine('$namespaces = Services::autoloader()->getNamespace();',1)
            ->addCodeLine('foreach ($namespaces as $namespace => $path) {',1)
            ->addCodeLine('if ($namespace === $ns) {',2)
            ->addCodeLine('$homepath = realpath(reset($path));',3)
            ->addCodeLine('break;',3)
            ->addCodeLine('}',2)
            ->addCodeLine('}',1)
            ->addCodeLine('} else {')
            ->addCodeLine('$ns = \'App\';',1)
            ->addCodeLine('}')
            ->addCodeLine('')
            ->addCodeLine('// kodlar...');


        $fs->dumpFile($commandPath, '<?php' . PHP_EOL . $command->toIndentedString());
        CLI::write('Dosya oluşturuldu : ' . CLI::color(str_replace($homepath, $ns, $commandPath), 'green'));
    }

}
