<?php


namespace GekTools\Tools\Xml;


use Gek\Collections\ArrayList;
use Gek\Collections\TypedListWrapper;


class XmlNodeList extends TypedListWrapper
{
    #region ctor

    /**
     * XmlNodeList constructor.
     * @param XmlNode ...$items
     */
    public function __construct(XmlNode ...$items)
    {
        parent::__construct(new ArrayList(), XmlNode::class);
        $this->addRange(...$items);
    }

    #endregion ctor

    #region methods

    /**
     * @param XmlNode $item
     */
    public function add(XmlNode $item):void{
        $this->innerList->add($item);
    }

    /**
     * @param XmlNode ...$items
     */
    public function addRange(XmlNode ...$items):void{
        $this->innerList->addRange($items);
    }



    /**
     * @param XmlNode $item
     * @return bool
     */
    public function contains(XmlNode $item):bool{
        return $this->innerList->contains($item);
    }

    /**
     * @param XmlNode  $item
     * @return bool
     */
    public function remove(XmlNode $item):bool{
        return $this->innerList->remove($item);
    }

    /**
     * @param XmlNode $item
     * @return int
     */
    public function indexOf(XmlNode $item): int{
        return $this->innerList->indexOf($item);
    }

    /**
     * @param int $index
     * @param XmlNode $item
     */
    public function insert(int $index, XmlNode $item): void{
        $this->innerList->insert($index,$item);
    }

    /**
     * @param int $index
     * @return XmlNode
     */
    public function getAt(int $index):XmlNode {
        return $this->innerList[$index];
    }

    /**
     * @param int $index
     * @param XmlNode ...$items
     */
    public function insertRange(int $index, XmlNode ...$items):void{
        $this->innerList->insertRange($index,$items);
    }

    #endregion methods

}