<?php


namespace GekTools\Tools;


use ArrayAccess;

class GenericModelData extends BaseModelData implements ArrayAccess
{
    #region fields

    /**
     * @var array
     */
    protected array $_innerDataArr = array();

    /**
     * @var array|null
     */
    protected ?array $_allowedFields = null;

    #endregion fields

    #region properties

    /**
     * @return array|null
     */
    public function getAllowedFields(): ?array
    {
        return $this->_allowedFields;
    }

    /**
     * @param array|null $allowedFields
     * @return GenericModelData
     */
    public function setAllowedFields(?array $allowedFields): GenericModelData
    {
        $this->_allowedFields = $allowedFields;
        return $this;
    }

    #endregion properties

    #region methods

    /**
     * @param string $fieldName
     * @return $this
     */
    public function addAllowedField(string $fieldName){
        if($this->_allowedFields === null){
            $this->_allowedFields = array();
        }
        if(! in_array($fieldName,$this->_allowedFields)){
            $this->_allowedFields[] = $fieldName;
        }
        return $this;
    }

    public function fillFromPostArray(array $postArray, ?int $index = null): void
    {
        foreach ($postArray as $ky => $vl){
            if(!empty($this->_allowedFields)){
                if(! in_array($ky,$this->_allowedFields)){
                    continue;
                }
            }
            if($index !== null && (! is_array($vl) || ! isset($vl[$index]))){
                continue;
            }
            $this->_innerDataArr[$ky] = ($index !== null) ? $vl[$index] : $vl;
        }
    }

    public function __set($name, $value)
    {
        $this->_innerDataArr[$name] = $value;
    }

    public function __get($name)
    {
        return $this->_innerDataArr[$name];
    }

    public function __isset($name)
    {
        return isset($this->_innerDataArr[$name]);
    }

    public function __unset($name)
    {
         unset($this->_innerDataArr[$name]);
    }


    #endregion methods

    #region ArrayAccess

    public function offsetExists($offset)
    {
        return isset($this->_innerDataArr[$offset]);
    }

    public function offsetGet($offset)
    {
        return $this->_innerDataArr[$offset];
    }

    public function offsetSet($offset, $value)
    {
        $this->_innerDataArr[$offset] = $value;
    }

    public function offsetUnset($offset)
    {
        unset($this->_innerDataArr[$offset]);
    }

    #endregion ArrayAccess

}
