<?php


namespace GekTools\Tools\Database;


use CodeIgniter\Entity;
use Gek\Collections\Typed\StringList;
use Gek\PhpLang\DocComments\DocComment;

class TableInfo
{
    #region fields

    private ?string $entityName = null;

    private string $tableName;

    private ?string $baseClass = Entity::class;

    private StringList $interfaces;

    private ?DocComment $docComment;


    #endregion fields

    #region ctor

    public function __construct(string $tableName = '')
    {
        $this->tableName = $tableName;
        $this->interfaces = new StringList();
    }

    #endregion ctor

    #region properties

    /**
     * entityName getter
     * @return string|null
     */
    public function getEntityName():?string {
        return $this->entityName;
    }

    /**
     * entityName setter
     *
     * @param string|null $entityName
     * @return $this
     */
    public function setEntityName(?string $entityName):self {
        $this->entityName = $entityName;
        return $this;
    }

    /**
     * entityName tanımlı mı
     *
     * @return bool
     */
    public function issetEntityName():bool {
        return $this->entityName !== null;
    }

    /**
     * tableName getter
     *
     * @return string
     */
    public function getTableName():string {
        return $this->tableName;
    }

    /**
     * tableName setter
     *
     * @param string $tableName
     * @return TableInfo
     */
    public function setTableName(string $tableName):self {
        $this->tableName = $tableName;
        return $this;
    }

    /**
     * baseClass getter
     *
     * @return string|null
     */
    public function getBaseClass():?string {
        return $this->baseClass;
    }

    /**
     * baseClass setter
     *
     * @param string|null $baseClass
     * @return TableInfo
     */
    public function setBaseClass(?string $baseClass):self {
        $this->baseClass = $baseClass;
        return $this;
    }

    /**
     * baseClass tanımlı mı
     *
     * @return bool
     */
    public function issetBaseClass():bool {
        return $this->baseClass !== null;
    }

    /**
     * interfaces getter
     *
     * @return StringList
     */
    public function getInterfaces():StringList{
        return $this->interfaces;
    }

    /**
     * interfaces setter
     *
     * @param StringList $interfaces
     * @return TableInfo
     */
    public function setInterfaces(StringList $interfaces):self {
        $this->interfaces = $interfaces->distinct()->toClass(StringList::class);
        return $this;
    }

    /**
     * docComment getter
     *
     * @return DocComment|null
     */
    public function getDocComment():?DocComment{
        return $this->docComment;
    }

    /**
     * docComment setter
     *
     * @param DocComment|null $docComment
     * @return TableInfo
     */
    public function setDocComment(?DocComment $docComment):self {
        $this->docComment = $docComment;
        return $this;
    }

    /**
     * docComment tanımlı mı
     *
     * @return bool
     */
    public function issetDocComment():bool {
        return $this->docComment !== null;
    }

    #endregion properties

    #region methods

    /**
     *  interface ekler
     * @param string $interface
     * @return TableInfo
     */
    public function addInterface(string $interface):self {
        if(!$this->interfaces->contains($interface)){
            $this->interfaces->add($interface);
        }
        return $this;
    }

    /**
     * interface siler
     *
     * @param string $interface
     * @return TableInfo
     */
    public function removeInterface(string $interface):self {
        if($this->interfaces->contains($interface)){
            $this->interfaces->remove($interface);
        }
        return $this;
    }


    #endregion methods


}
