<?php


namespace GekTools\Tools\Collections;


use Gek\Collections\ArrayList;
use Gek\Collections\IEnumerable;
use Traversable;

class PagedResult extends ArrayList
{

    #region fields

    protected int $totalCount = 0;

    protected int $pageIndex = 0;

    protected int $pageSize = 0;

    protected string $orderedField = 'id';

    protected string $orderedDirection = 'asc';

    #endregion fields

    #region ctor

    /**
     * PagedResult constructor.
     * @param array|Traversable|IEnumerable|null $enumerable
     * @param int $pageIndex
     * @param int $pageSize
     * @param int $totalCount
     * @param string $orderedField
     * @param string $orderedDirection
     */
    public function __construct($enumerable = null, int $pageIndex = 0, int $pageSize = 0, int $totalCount = 0, string $orderedField = 'id',string $orderedDirection = 'asc')
    {
        parent::__construct($enumerable);
        $this->totalCount = $totalCount;
        $this->pageIndex = $pageIndex;
        $this->pageSize = $pageSize;
        $this->orderedField = $orderedField;
        $this->orderedDirection = $orderedDirection;
    }

    #endregion ctor

    #region properties

    /**
     * @return int
     */
    public function getTotalCount(): int
    {
        return $this->totalCount;
    }

    /**
     * @param int $totalCount
     * @return $this
     */
    public function setTotalCount(int $totalCount): self
    {
        $this->totalCount = $totalCount;
        return $this;
    }

    /**
     * @return int
     */
    public function getPageIndex(): int
    {
        return $this->pageIndex;
    }

    /**
     * @param int $pageIndex
     * @return $this
     */
    public function setPageIndex(int $pageIndex): self
    {
        $this->pageIndex = $pageIndex;
        return $this;
    }

    /**
     * @return int
     */
    public function getPageSize(): int
    {
        return $this->pageSize;
    }

    /**
     * @param int $pageSize
     * @return $this
     */
    public function setPageSize(int $pageSize): self
    {
        $this->pageSize = $pageSize;
        return $this;
    }

    /**
     * @return string
     */
    public function getOrderedField():string {
        return $this->orderedField;
    }

    /**
     * @param string $orderedField
     * @return $this
     */
    public function setOrderedField(string $orderedField):self {
        $this->orderedField = $orderedField;
        return $this;
    }

    /**
     * @return string
     */
    public function getOrderedDirection():string {
        return $this->orderedDirection;
    }

    /**
     * @param string $orderedDirection
     * @return $this
     */
    public function setOrderedDirection(string $orderedDirection):self {
        $this->orderedDirection = $orderedDirection;
        return $this;
    }

    #endregion properties

    #region methods
    /**
     * @return int
     */
    public function getTotalPageCount(): int
    {
        $totalPages = (int)floor($this->totalCount / $this->pageSize);
        if (($this->totalCount % $this->pageSize) > 0) {
            $totalPages++;
        }
        return $totalPages;
    }

    /**
     * @return bool
     */
    public function hasPrevPage(): bool
    {
        return $this->pageIndex > 0;
    }

    public function hasNextPage(): bool
    {
        return $this->pageIndex < $this->getTotalPageCount();
    }
    #endregion methods

}
