<?php


namespace GekTools\Tools\Cache;


use CodeIgniter\Cache\CacheInterface;

interface IDataCache extends CacheInterface
{

    /**
     * @param string $key
     * @param callable $func
     * @param array $args
     * @param int $ttl
     * @return mixed
     */
    public function getOrSave(string $key, callable $func, array $args = [], int $ttl = 60);

    /**
     * @param string $keyRegex
     * @return bool
     */
    public function deleteByRegex(string $keyRegex);

    /**
     * @param string $keyStartWith
     * @return bool
     */
    public function deleteByStartWith(string $keyStartWith);
}