<?php
namespace GekTools\Tasks\Entities\Extensions;

use CodeIgniter\I18n\Time;
use GekTools\Tasks\Entities\ScheduleTask;

/**
 * Trait ScheduleTaskTrait
 * @mixin ScheduleTask
 */
trait ScheduleTaskTrait
{
    /**
     * @return bool
     * @throws \Exception
     */
    public function check():bool {
        if (!$this->getEnabled()){
            return false;
        }
        if ($this->getLastStartUtc() === null){
            return true;
        }
        if ($this->getLastEndUtc() === null){
            return true;
        }
        $lastEnd = $this->getLastEndUtc();
        $lastEnd = $lastEnd->addSeconds($this->getSeconds());
        return $lastEnd->isBefore(Time::now('UTC'));
    }

}
