<?php

namespace GekTools\Tasks\Database\Migrations;

use CodeIgniter\Database\Migration;
use GekTools\Tools\Traits\MigrationTrait;

class CreateScheduleTasks extends Migration
{

    use MigrationTrait;

    protected string $tableName = 'schedule_tasks';

    protected string $pkName = 'id';

    public function up(){
        $this->entityName = 'ScheduleTask';
        $this->namespace = 'GekTools\\Tasks';
        $this->addPrimaryKeyField($this->pkName);

        $this->addStringField('name', 300)
            ->addIntField('seconds',false,true,false,3600)
            ->addStringField('className',300)
            ->addBoolField('enabled')
            ->addBoolField('stopOnError')
            ->addDateTimeField('lastStartUtc',true)
            ->addDateTimeField('lastEndUtc',true)
            ->addDateTimeField('lastSuccessUtc',true);

        $this->createTable($this->tableName);
    }

    public function down(){
        $this->forge->dropTable($this->tableName);
    }

}
