<?php


namespace GekTools\Membership\Database\Seeds;



use CodeIgniter\Database\Seeder;
use GekTools\Membership\PasswordFormat;
use GekTools\Membership\SystemRoleNames;
use GekTools\Membership\SystemUserNames;
use GekTools\Membership\UserStatus;
use GekTools\Tools\Guid;

class UserSeeds extends Seeder
{

    public function run()
    {
        $data = array(
            'userGuid' => Guid::create(),
            'name' => 'Atakan',
            'lastName' => 'Çalışkan',
            'email' => 'atakan2caliskan@gmail.com',
            'userName' => 'atakan',
            'phone' => null,
            'passwordHash' => md5('powerpc@1643'),
            'passwordFormat' => PasswordFormat::MD5,
            'adminNotes' => null,
            'systemAccount' => false,
            'systemName' => null,
            'lastIp' => '::1',
            'status' => UserStatus::ACTIVE,
            'lastLoginDateUtc' => null,
            'lastActivityDataUtc' => null,
            'createdAtUtc' => gmdate('Y-m-d H:i:s'),
            'updatedAtUtc' => null,
            'deletedAtUtc' => null,
        );
        $this->addOrUpdate($data);


        $data = array(
            'userGuid' => Guid::create(),
            'name' => 'Süleyman',
            'lastName' => 'Efe',
            'email' => 'suleyman.efe@live.com',
            'userName' => 'suleyman',
            'phone' => null,
            'passwordHash' => md5('1907fenerli-*-*'),
            'passwordFormat' => PasswordFormat::MD5,
            'adminNotes' => null,
            'systemAccount' => false,
            'systemName' => null,
            'lastIp' => '::1',
            'status' => UserStatus::ACTIVE,
            'lastLoginDateUtc' => null,
            'lastActivityDataUtc' => null,
            'createdAtUtc' => gmdate('Y-m-d H:i:s'),
            'updatedAtUtc' => null,
            'deletedAtUtc' => null,
        );
        $this->addOrUpdate($data);

        $data = array(
            'userGuid' => Guid::create(),
            'name' => null,
            'lastName' => null,
            'email' => 'builtin@background_task.com',
            'userName' => 'builtin@background_task.com',
            'phone' => null,
            'passwordHash' => null,
            'passwordFormat' => PasswordFormat::MD5,
            'adminNotes' => 'Arka plan görevleri için kullanılan yerleşik kullanıcı.',
            'systemAccount' => true,
            'systemName' => SystemUserNames::BACKGROUND_TASK,
            'lastIp' => '::1',
            'status' => UserStatus::ACTIVE,
            'lastLoginDateUtc' => null,
            'lastActivityDataUtc' => null,
            'createdAtUtc' => gmdate('Y-m-d H:i:s'),
            'updatedAtUtc' => null,
            'deletedAtUtc' => null,
        );
        $this->addOrUpdate($data);

        $data = array(
            'userGuid' => Guid::create(),
            'name' => null,
            'lastName' => null,
            'email' => 'builtin@search_engine.com',
            'userName' => 'builtin@search_engine.com',
            'phone' => null,
            'passwordHash' => null,
            'passwordFormat' => PasswordFormat::MD5,
            'adminNotes' => 'Yerleşik misafir kullanıcısı, arama motorlarından gelen istekler için kullanılır.',
            'systemAccount' => true,
            'systemName' => SystemUserNames::SEARCH_ENGINE,
            'lastIp' => '::1',
            'status' => UserStatus::ACTIVE,
            'lastLoginDateUtc' => null,
            'lastActivityDataUtc' => null,
            'createdAtUtc' => gmdate('Y-m-d H:i:s'),
            'updatedAtUtc' => null,
            'deletedAtUtc' => null,
        );
        $this->addOrUpdate($data);

        $atakan = $this->db->table('users')->where('userName','atakan')->get()->getRow(0);
        $suleyman = $this->db->table('users')->where('userName','suleyman')->get()->getRow(0);
        $background_task = $this->db->table('users')->where('systemName',SystemUserNames::BACKGROUND_TASK)->get()->getRow(0);
        $search_engine = $this->db->table('users')->where('systemName',SystemUserNames::SEARCH_ENGINE)->get()->getRow(0);

        $system_admin = $this->db->table('user_roles')->where('systemName',SystemRoleNames::SYSTEM_ADMIN)->get()->getRow(0);
        $admin = $this->db->table('user_roles')->where('systemName',SystemRoleNames::ADMINISTARATORS)->get()->getRow(0);
        $registered = $this->db->table('user_roles')->where('systemName',SystemRoleNames::REGISTERED)->get()->getRow(0);
        $guest = $this->db->table('user_roles')->where('systemName',SystemRoleNames::GUESTS)->get()->getRow(0);

        $this->addMap($atakan->id,$system_admin->id);

        $this->addMap($atakan->id,$admin->id);

        $this->addMap($atakan->id,$registered->id);

        $this->addMap($suleyman->id,$system_admin->id);

        $this->addMap($suleyman->id,$admin->id);

        $this->addMap($suleyman->id,$registered->id);

        $this->addMap($background_task->id,$guest->id);

        $this->addMap($search_engine->id,$guest->id);

    }

    protected function addMap($userId, $roleId){
        $map = $this->db->table('user_role_mappings')
            ->where('userId', $userId)
            ->where('roleId', $roleId)
            ->get()->getRow(0);
        if(empty($map)){
            $data = array(
                'userId' => $userId,
                'roleId' => $roleId,
            );
            $this->db->table('user_role_mappings')->insert($data);
        }
    }

    protected function addOrUpdate($row){
        $obj = $this->db->table('users')
            ->where('email', $row['email'])
            ->get()->getRow(0);
        if(!empty($obj)){
            unset($row['userGuid']);
            unset($row['lastIp']);
            unset($row['lastLoginDateUtc']);
            unset($row['lastActivityDataUtc']);
            unset($row['createdAtUtc']);
            unset($row['deletedAtUtc']);
            $row['updatedAtUtc'] = gmdate('Y-m-d H:i:s');
            $this->db->table('users')->update($row,['id' => $obj->id]);
        }else{
            $this->db->table('users')->insert($row);
        }

    }
}
