<?php 

namespace GekTools\Membership\Database\Migrations;

use CodeIgniter\Database\Migration;
use GekTools\Membership\PasswordFormat;
use GekTools\Membership\UserStatus;
use GekTools\Tools\Traits\MigrationTrait;

class CreateUsers extends Migration 
{

    use MigrationTrait;

    protected string $tableName = 'users';

    protected string $pkName = 'id';

    public function up(){
        $this->entityName = 'User';
        $this->namespace = 'GekTools\\Membership';
        $this->addPrimaryKeyField($this->pkName);

        $this->addGuidField('userGuid')
            ->addStringField('name',60,true)
            ->addStringField('lastName',60,true)
            ->addEmailField('email',true,false)
            ->addStringField('userName',60,true)
            ->addStringField('phone',20,true)
            ->addKey('userName')
            ->addStringField('passwordHash',300,true)
            ->addEnumField('passwordFormat',PasswordFormat::class,PasswordFormat::MD5)
            ->addTextField('adminNotes',true)
            ->addBoolField('systemAccount',false,false)
            ->addSystemNameField()
            ->addStringField('lastIp',60)
            ->addEnumField('status', UserStatus::class,UserStatus::WAITING_CONFIRM)
                ->addDateTimeField('lastLoginDateUtc',true)
            ->addDateTimeField('lastActivityDataUtc',true)
            ->addCreatedAtUtc()
            ->addUpdatedAtUtc()
            ->addSoftDeletableField();

        $this->createTable($this->tableName);
    }

    public function down(){
        $this->forge->dropTable($this->tableName);
    }

}
