<?php
namespace GekTools\Currencies\Settings;

use GekTools\Settings\ISettings;

class CurrencySettings implements ISettings
{

    #region fields

    /**
     * @var bool
     */
    protected bool $displayLabel = false;

    /**
     * @var int
     */
    protected int $primarySystemCurrencyId = 0;

    /**
     * @var int
     */
    protected int $primaryExchangeRateCurrencyId = 0;

    /**
     * @var string|null
     */
    protected ?string $exchangeRatesProvider = null;

    /**
     * @var bool
     */
    protected bool $autoUpdate = false;

    #endregion fields

    #region properties

    /**
     * @return bool
     */
    public function isDisplayLabel(): bool
    {
        return $this->displayLabel;
    }

    /**
     * @param bool $displayLabel
     * @return \GekTools\Settings\CurrencySettings
     */
    public function setDisplayLabel(bool $displayLabel): self
    {
        $this->displayLabel = $displayLabel;
        return $this;
    }

    /**
     * @return int
     */
    public function getPrimarySystemCurrencyId(): int
    {
        return $this->primarySystemCurrencyId;
    }

    /**
     * @param int $primarySystemCurrencyId
     * @return $this
     */
    public function setPrimarySystemCurrencyId(int $primarySystemCurrencyId): self
    {
        $this->primarySystemCurrencyId = $primarySystemCurrencyId;
        return $this;
    }

    /**
     * @return int
     */
    public function getPrimaryExchangeRateCurrencyId(): int
    {
        return $this->primaryExchangeRateCurrencyId;
    }

    /**
     * @param int $primaryExchangeRateCurrencyId
     * @return $this
     */
    public function setPrimaryExchangeRateCurrencyId(int $primaryExchangeRateCurrencyId): self
    {
        $this->primaryExchangeRateCurrencyId = $primaryExchangeRateCurrencyId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getExchangeRatesProvider(): ?string
    {
        return $this->exchangeRatesProvider;
    }

    /**
     * @param string|null $exchangeRatesProvider
     * @return $this
     */
    public function setExchangeRatesProvider(?string $exchangeRatesProvider): self
    {
        $this->exchangeRatesProvider = $exchangeRatesProvider;
        return $this;
    }

    /**
     * @return bool
     */
    public function isAutoUpdate(): bool
    {
        return $this->autoUpdate;
    }

    /**
     * @param bool $autoUpdate
     * @return $this
     */
    public function setAutoUpdate(bool $autoUpdate): self
    {
        $this->autoUpdate = $autoUpdate;
        return $this;
    }

    #endregion properties
}
