<?php


namespace GekTools\Commands;


use CodeIgniter\CLI\BaseCommand;
use CodeIgniter\CLI\CLI;
use CodeIgniter\Config\BaseService;
use Config\Services;
use Gek\Filesystem\Filesystem;
use Gek\PhpLang\CodeFactory;


class CreateConfigServices  extends BaseCommand
{

    protected $group = 'Ci4Tools';
    protected $name = 'create:config-services';
    protected $description = 'Config Services sınıfı oluşturur.';

    /**
     * the Command's usage
     *
     * @var string
     */
    protected $usage = 'create:config-services [Options]';

    /**
     * the Command's Arguments
     *
     * @var array
     */
    protected $arguments = [];

    /**
     * the Command's Options
     *
     * @var array
     */
    protected $options = [
        '-n' => 'namespace ayarlar.',
    ];


    /**
     * Actually execute a command.
     * This has to be over-ridden in any concrete implementation.
     *
     * @param array $params
     * @throws \Throwable
     */
    public function run(array $params)
    {
        helper('inflector');



        $ns = $params['-n'] ?? CLI::getOption('n');

        $homepath = APPPATH;

        if (!empty($ns)) {
            // Get all namespaces
            $namespaces = Services::autoloader()->getNamespace();

            foreach ($namespaces as $namespace => $path) {
                if ($namespace === $ns) {
                    $homepath = realpath(reset($path));
                    break;
                }
            }
        } else {
            $ns = 'App';
        }

        $servicesNs = $ns . '\\Config';
        $servicesPath = $homepath . "/Config/Services.php";
        $fs = new Filesystem();

        if ($fs->exists($servicesPath)) {
            CLI::error('Dosya zaten mevcut : ' . str_replace($homepath, $ns, $servicesPath));
            return;
        }

        $service = CodeFactory::classCreate('Services')
            ->setNamespace($servicesNs)
            ->setExtends(BaseService::class);

        $sampleFn = $service->addMethod('sampleService')
            ->setPublic()
            ->setStatic()
            ->addParams('$getShared = true')
            ->addCodeLine('if ($getShared)')
            ->addCodeLine('{')
            ->addCodeLine('return static::getSharedInstance(\'sampleService\');',1)
            ->addCodeLine('}')
            ->addCodeLine('return new SampleService();');

        $fs->dumpFile($servicesPath, '<?php' . PHP_EOL . $service->toIndentedString());
        CLI::write('Dosya oluşturuldu : ' . CLI::color(str_replace($homepath, $ns, $servicesPath), 'green'));
    }

}
