<?php


namespace GekTools;


use CodeIgniter\Config\Services;
use CodeIgniter\I18n\Time;
use GekTools\Membership\Entities\User;
use GekTools\Membership\MembershipService;
use GekTools\Membership\SystemUserNames;
use GekTools\Membership\UserService;
use GekTools\Membership\UserStatus;

class WorkContext
{

    #region fields

    /**
     * @var User|null
     */
    protected ?User $currentUser = null;

    /**
     * @var User|null
     */
    protected ?User $originalUserIfImpersonated = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }



    #endregion ctor

    #region Properties

    /**
     * @return User|null
     */
    public function getCurrentUser(): ?User
    {
        if($this->currentUser != null){
            return $this->currentUser;
        }
        $user = null;
        $userService = UserService::instance();
        $membershipService = MembershipService::instance();
        $request = Services::request();

        $lastActDate = Time::now('UTC');

        if(is_cli()){
            $user = $userService->getUserBySystemName(SystemUserNames::BACKGROUND_TASK);
        }

        if(empty($user) || $user->getStatus()->toInt() != UserStatus::ACTIVE){
            if($request->getUserAgent()->isRobot()){
                $user = $userService->getUserBySystemName(SystemUserNames::SEARCH_ENGINE);
            }
        }

        if(empty($user) || $user->getStatus()->toInt() != UserStatus::ACTIVE){
            $user = $membershipService->getAuthenticatedUser();
            if(!empty($user) && $user->getStatus()->toInt() == UserStatus::ACTIVE && $user->checkPermission('AllowUserImpersonation')){
                $impersonatedUserId =  $user->getGenericAttributeValue('ImpersonatedUserId');
                if(!empty($impersonatedUserId)){
                    /** @var User|null $impersonatedUser */
                    $impersonatedUser = $userService->getUserModel()->getById($impersonatedUserId);
                    if(!empty($impersonatedUser) && $impersonatedUser->getStatus()->toInt() == UserStatus::ACTIVE ){
                        $this->originalUserIfImpersonated = $user;
                        $user = $impersonatedUser;
                    }
                }

            }
        }

        if(empty($user) || $user->getStatus()->toInt() != UserStatus::ACTIVE){
            $user = $membershipService->getGuestUser();
        }

        $this->currentUser = $user;
        return $this->currentUser;
    }



    /**
     * @return User|null
     */
    public function getOriginalUserIfImpersonated(): ?User
    {
        return $this->originalUserIfImpersonated;
    }

    #endregion Properties

    #region static

    /**
     * @return WorkContext
     */
    public static function instance():self {
        return service('workContext', true);
    }

    #endregion static

}