<?php


namespace GekTools\Tools\Validations;




class Validation
{
    #region fields

    protected string $name = '';

    protected array $arguments = array();

    protected bool $useModel = true;

    protected bool $useModelData = true;

    #endregion fields

    #region ctor

    public function __construct(string $name = '')
    {
        $this->setName($name);
    }

    #endregion ctor

    #region properties

    /**
     * @return string
     */
    public function getName():string {
        return $this->name;
    }

    /**
     * @param string $name
     * @return $this
     */
    public function setName(string $name):self {
        $this->name = strtolower(trim($name));
        return $this;
    }

    /**
     * @return array
     */
    public function getArguments():array{
        return $this->arguments;
    }

    /**
     * @param array $arguments
     * @return $this
     */
    public function setArguments(array $arguments):self {
        $this->arguments = $arguments;
        return $this;
    }

    /**
     * @return bool
     */
    public function getUseModel():bool{
        return $this->useModel;
    }

    /**
     * @param bool $useModel
     * @return self
     */
    public function setUseModel(bool $useModel):self {
        $this->useModel = $useModel;
        return $this;
    }

    /**
     * @return bool
     */
    public function getUseModelData():bool {
        return $this->useModelData;
    }

    /**
     * @param bool $useModelData
     * @return $this
     */
    public function setUseModelData(bool $useModelData):self {
        $this->useModelData = $useModelData;
        return $this;
    }




    #endregion properties

    #region Methods

    /**
     * @internal
     * @return array
     */
    public function toArrayForSerialize():array {
        $data = [
            'n' => $this->name
        ];
        if(!empty($this->arguments)){
            $data['a'] = $this->arguments;
        }
        if(!$this->getUseModel()){
            $data['om'] = 0;
        }
        if(!$this->getUseModelData()){
            $data['omd'] = 0;
        }
        return $data;
    }

    /**
     * @param string $argument
     * @return $this
     */
    public function addArgument(string $argument):self {
        $this->arguments[] = trim($argument);
        return $this;
    }

    public function __toString()
    {
        $res = $this->name;
        if(!empty($this->arguments)){
            $res .= '[';
            $res .= implode(',',$this->arguments);
            $res .= ']';
        }
        return $res;
    }

    #endregion Methods

    #region statics

    /**
     * @internal
     * @param array $data
     * @return Validation
     */
    public static function fromSerializeArray(array $data):self{
        $res = new Validation($data['n']);
        if(isset($data['a'])){
            $res->setArguments($data['a']);
        }
        if(isset($data['om']) && $data['om'] == 0){
            $res->setUseModel(false);
        }
        if(isset($data['omd']) && $data['omd'] == 0){
            $res->setUseModelData(false);
        }
        return $res;
    }

    #endregion statics

}
