<?php
namespace GekTools\Tasks\Commands;

use CodeIgniter\CLI\CLI;
use Config\Services;
use CodeIgniter\CLI\BaseCommand;
use Gek\Filesystem\Filesystem;
use Gek\Infrastructure\Str;
use Gek\PhpLang\CodeFactory;
use Gek\PhpLang\LiteralTypes;
use GekTools\Settings\ISettings;
use GekTools\Tasks\ITask;

class CreateTask extends BaseCommand
{

    protected $group = 'Ci4Tools';

    protected $name = 'create:task';

    protected $description = 'Yeni bir task oluşturur.';

    /**
     * the Command's usage

     *
     * @var string
     */
    protected $usage = 'create:task [task_name] [Options]';

    /**
     * the Command's Arguments

     *
     * @var array
     */
    protected $arguments = [
        'task_name' => 'Task adı.',
    ];

    /**
     * the Command's Options

     *
     * @var array
     */
    protected $options = [
        '-n' => 'Namespace ayarlar.',
        '-p' => 'path ayarlar'
    ];

    public function run(array $params){
        $taskName = array_shift($params);

        if (empty($taskName)) {
            $taskName = CLI::prompt('Task adını girin');
        }

        $taskName = ucfirst($taskName);

        if(! Str::endsWith($taskName,'Task')){
            $taskName .= 'Task';
        }

        $ns = $params['-n'] ?? CLI::getOption('n');
        $homepath = APPPATH;

        if (!empty($ns)) {
            // Get all namespaces
            $namespaces = Services::autoloader()->getNamespace();
            foreach ($namespaces as $namespace => $path) {
                if ($namespace === $ns) {
                    $homepath = realpath(reset($path));
                    break;
                }
            }
        } else {
            $ns = 'App';
        }

        $path = $params['-p'] ?? CLI::getOption('p');

        if (!empty($path)) {
            $path = str_replace(["/", "\\"], DIRECTORY_SEPARATOR, $path);
            $path = trim($path);
            $path = trim($path, DIRECTORY_SEPARATOR);
        }else{
            $path = 'Tasks' . DIRECTORY_SEPARATOR;
        }
        $taskPath = $homepath . DIRECTORY_SEPARATOR . $path . DIRECTORY_SEPARATOR . $taskName . '.php';
        $taskNs = $ns . '\\' . str_replace(DIRECTORY_SEPARATOR,'\\',$path);
        $taskNs = trim($taskNs,'\\');
        $fs = new Filesystem();

        if ($fs->exists($taskPath)) {
            CLI::error('Dosya zaten mevcut : ' . str_replace($homepath, $ns, $taskPath));
            return;
        }

        $task = CodeFactory::classCreate($taskName)
            ->addImplement(ITask::class)
            ->setNamespace($taskNs);

        $executeFn = $task->addMethod('execute')
            ->setReturnType('bool')
            ->addCodeLine('// Kodlar...')
            ->autoDocComment()
            ->addCommentSummary('Görevi Çalıştır')
            ->setRegion('ITask');

        $fs->dumpFile($taskPath, '<?php' . PHP_EOL . $task->toIndentedString());
        CLI::write('Dosya oluşturuldu : ' . CLI::color(str_replace($homepath, $ns, $taskPath), 'green'));

    }


}
