<?php

namespace GekTools\Settings\Database\Migrations;

use CodeIgniter\Database\Migration;
use GekTools\Tools\Traits\MigrationTrait;

class CreateSettings extends Migration
{

    use MigrationTrait;

    protected string $tableName = 'settings';

    protected string $pkName = 'id';

    public function up(){
        $this->entityName = 'Setting';
        $this->namespace = 'GekTools\\Settings';
        $this->addPrimaryKeyField($this->pkName);

        $this->addStringField('name',300)
            ->addTextField('value',true)
            ->addStringField('type',300)
            ->addBoolField('nullable')
            ->addCreatedAtUtc()
            ->addUpdatedAtUtc();

        $this->createTable($this->tableName);
    }

    public function down(){
        $this->forge->dropTable($this->tableName);
    }

}
