<?php
namespace GekTools\Membership\Entities\Extensions;

use Gek\Collections\ArrayList;
use GekTools\Membership\Entities\PermissionRecord;
use GekTools\Membership\PermissionsService;
use GekTools\Tools\Collections\PagedResult;

/**
 * Trait UserRoleTrait
 *
 */ 
trait UserRoleTrait 
{

    #region fields

    /**
     * @var ArrayList|null
     */
    protected ?ArrayList $permissionSystemNames = null;

    /**
     * @var PagedResult|PermissionRecord[]|null
     */
    protected ?PagedResult $permissions = null;

    #endregion fields

    #region methods

    /**
     * @return PermissionRecord[]|PagedResult
     */
    public function getPermissionRecords(){
        if($this->permissions === null){
            $this->permissions = PermissionsService::instance()
                ->getPermissionRecordsByUserRoleId($this->getId());
        }
        return $this->permissions;
    }

    /**
     * @return ArrayList|null
     */
    public function getPermissionSystemNames(){
        if($this->permissionSystemNames === null){
            $this->permissionSystemNames = $this->getPermissionRecords()
                ->select(function (PermissionRecord $r){
                    return $r->getSystemName();
                })->toArrayList();
        }
        return $this->permissionSystemNames;
    }

    /**
     * @param string $permissionSystemName
     * @return bool
     */
    public function checkPermission(string $permissionSystemName):bool {
        return $this->getPermissionSystemNames()->contains($permissionSystemName);
    }

    #endregion methods

}
