<?php

namespace GekTools\Membership\Database\Seeds;

use CodeIgniter\Database\Seeder;
use GekTools\Membership\SystemRoleNames;

class RoleSeeds extends Seeder
{

    public function run()
    {
        $row = [
            'name' => 'Yöneticiler',
            'systemName' => SystemRoleNames::ADMINISTARATORS,
            'Active' => true,
        ];
        $this->addOrUpdate($row);



        $row = [
            'name' => 'Sistem Yöneticileri',
            'systemName' => SystemRoleNames::SYSTEM_ADMIN,
            'Active' => true,
        ];

        $this->addOrUpdate($row);

        $row = [
            'name' => 'Kayıtlı Kullanıcılar',
            'systemName' => SystemRoleNames::REGISTERED,
            'Active' => true,
        ];

        $this->addOrUpdate($row);

        $row = [
            'name' => 'Misafirler',
            'systemName' => SystemRoleNames::GUESTS,
            'Active' => true,
        ];

        $this->addOrUpdate($row);
    }

    protected function addOrUpdate($row){
        $obj = $this->db->table('user_roles')
            ->where('systemName', $row['systemName'])
            ->get()->getRow(0);
        if(!empty($obj)){
            $this->db->table('user_roles')->update($row,['id' => $obj->id]);
        }else{
            $this->db->table('user_roles')->insert($row);
        }

    }
}
