<?php 

namespace GekTools\Membership\Database\Migrations;

use CodeIgniter\Database\Migration;
use GekTools\Tools\Traits\MigrationTrait;

class CreateUserRoles extends Migration 
{

    use MigrationTrait;

    protected string $tableName = 'user_roles';

    protected string $pkName = 'id';

    public function up(){
        $this->entityName = 'UserRole';
        $this->namespace = 'GekTools\\Membership';
        $this->addPrimaryKeyField($this->pkName);

        $this->addStringField('name',60)
            ->addSystemNameField()
            ->addBoolField('active');

        $this->createTable($this->tableName);
    }

    public function down(){
        $this->forge->dropTable($this->tableName);
    }

}
