<?php
namespace GekTools\Membership\Config;

use CodeIgniter\Config\BaseService;
use GekTools\Membership\MembershipService;
use GekTools\Membership\PermissionsService;
use GekTools\Membership\UserRegistrationsService;
use GekTools\Membership\UserService;

class Services extends BaseService
{

    /**
     * @param bool $getShared
     * @return MembershipService|mixed
     */
    public static function membershipService($getShared = true){
        if ($getShared)
        {
            return static::getSharedInstance('membershipService');
        }
        return new MembershipService();
    }

    /**
     * @param bool $getShared
     * @return UserService|mixed
     */
    public static function userService($getShared = true){
        if ($getShared)
        {
            return static::getSharedInstance('userService');
        }
        return new UserService();
    }

    /**
     * @param bool $getShared
     * @return UserRegistrationsService|mixed
     */
    public static function userRegistrationsService($getShared = true){
        if ($getShared)
        {
            return static::getSharedInstance('userRegistrationsService');
        }
        return new UserRegistrationsService();
    }

    /**
     * @param bool $getShared
     * @return PermissionsService|mixed
     */
    public static function permissionsService($getShared = true){
        if ($getShared)
        {
            return static::getSharedInstance('permissionsService');
        }
        return new PermissionsService();
    }

}