<?php

namespace GekTools\Locale\Database\Migrations;

use CodeIgniter\Database\Migration;
use GekTools\Tools\Traits\MigrationTrait;

class CreateLanguages extends Migration
{

    use MigrationTrait;

    protected string $tableName = 'languages';

    protected string $pkName = 'id';

    public function up(){
        $this->entityName = 'Language';
        $this->namespace = 'GekTools\\Locale';
        $this->addPrimaryKeyField($this->pkName);
        $this->addStringField('name',100,false,true)
            ->addSystemNameField()
            ->addStringField('culture',20,false,true)
            ->addStringField('uniqueSeoCode',2,false,true)
            ->addBoolField('rtl',false,false)
            ->addStringField('currencyCode',3,true)
            ->addDisplayOrder()
            ->addBoolField('published',false);

        $this->createTable($this->tableName);
    }

    public function down(){
        $this->forge->dropTable($this->tableName);
    }

}
