<?php


namespace GekTools\Tools\Html;


class CommentNode extends TextNode
{
    private const OPEN = '<!-- ';
    private const CLOSE = ' -->';

    #region ctor

    /**
     * CommentNode constructor.
     * @param string $comment
     */
    public function __construct(string $comment = '')
    {
        parent::__construct($comment);
    }

    #endregion ctor

    #region methods

    /**
     * @return string
     */
    public function toHtmlString(): string
    {
        $res = parent::toHtmlString();
        return static::OPEN . $res . static::CLOSE;
    }


    #endregion methods

}