<?php
namespace GekTools\Membership\Settings;

use GekTools\Membership\RegistrationType;
use GekTools\Settings\ISettings;

class MembershipSettings implements ISettings 
{

    #region fields

    /**
     *  E-postalar yerine kullanıcı adlarının kullanılıp kullanılmayacağını belirler
     *
     * @var bool
     */
    protected bool $userNamesEnabled = false;

    /**
     * Kullanıcıların kullanıcı adlarının kullanılabilirliğini kontrol edip edemeyeceklerini belirten bir değer alır.
     *
     * @var bool
     */
    protected bool $checkUserNamesAvailabilityEnabled = false;

    /**
     * Kullanıcıların kullanıcı adlarını değiştirip değiştiremeyeceğini belirten bir değer alır
     *
     * @var bool
     */
    protected bool $allowUsersToChangeUserNames = false;

    /**
     * Kullanıcı kayıt senaryo tipi
     *
     * @var int
     */
    protected int $userRegistrationType = RegistrationType::STANDARD;

    /**
     * Asgari şifre uzunluğunu belirler.
     *
     * @var int
     */
    protected int $passwordMinLength = 8;


    /**
     * Şifre kurtarma linki geçerlilik süresi (gün cinsinden)
     *
     * @var int
     */
    protected int $passwordRecoveryLinkDaysValid = 2;


    /**
     * Yeni kullanıcı kaydı olduğunda adminlere bildir.
     *
     * @var bool
     */
    protected bool $notifyNewCustomerRegistration = false;

    /**
     * Telefon no alanını aktif ya da pasif yapar
     *
     * @var bool
     */
    protected bool $phoneEnabled = false;

    /**
     * Telefon no alanının zorunlu alan olup ulmadığını ayarlar.
     *
     * @var bool
     */
    protected bool $phoneRequired = false;

    #endregion fields

    #region properties

    /**
     * @return bool
     */
    public function isUserNamesEnabled(): bool
    {
        return $this->userNamesEnabled;
    }

    /**
     * @param bool $userNamesEnabled
     * @return MembershipSettings
     */
    public function setUserNamesEnabled(bool $userNamesEnabled): MembershipSettings
    {
        $this->userNamesEnabled = $userNamesEnabled;
        return $this;
    }

    /**
     * @return bool
     */
    public function isCheckUserNamesAvailabilityEnabled(): bool
    {
        return $this->checkUserNamesAvailabilityEnabled;
    }

    /**
     * @param bool $checkUserNamesAvailabilityEnabled
     * @return MembershipSettings
     */
    public function setCheckUserNamesAvailabilityEnabled(bool $checkUserNamesAvailabilityEnabled): MembershipSettings
    {
        $this->checkUserNamesAvailabilityEnabled = $checkUserNamesAvailabilityEnabled;
        return $this;
    }

    /**
     * @return bool
     */
    public function isAllowUsersToChangeUserNames(): bool
    {
        return $this->allowUsersToChangeUserNames;
    }

    /**
     * @param bool $allowUsersToChangeUserNames
     * @return MembershipSettings
     */
    public function setAllowUsersToChangeUserNames(bool $allowUsersToChangeUserNames): MembershipSettings
    {
        $this->allowUsersToChangeUserNames = $allowUsersToChangeUserNames;
        return $this;
    }

    /**
     * @return int
     */
    public function getUserRegistrationType(): int
    {
        return $this->userRegistrationType;
    }

    /**
     * @param int $userRegistrationType
     * @return MembershipSettings
     */
    public function setUserRegistrationType(int $userRegistrationType): MembershipSettings
    {
        $this->userRegistrationType = $userRegistrationType;
        return $this;
    }

    /**
     * @return int
     */
    public function getPasswordMinLength(): int
    {
        return $this->passwordMinLength;
    }

    /**
     * @param int $passwordMinLength
     * @return MembershipSettings
     */
    public function setPasswordMinLength(int $passwordMinLength): MembershipSettings
    {
        $this->passwordMinLength = $passwordMinLength;
        return $this;
    }

    /**
     * @return int
     */
    public function getPasswordRecoveryLinkDaysValid(): int
    {
        return $this->passwordRecoveryLinkDaysValid;
    }

    /**
     * @param int $passwordRecoveryLinkDaysValid
     * @return MembershipSettings
     */
    public function setPasswordRecoveryLinkDaysValid(int $passwordRecoveryLinkDaysValid): MembershipSettings
    {
        $this->passwordRecoveryLinkDaysValid = $passwordRecoveryLinkDaysValid;
        return $this;
    }

    /**
     * @return bool
     */
    public function isNotifyNewCustomerRegistration(): bool
    {
        return $this->notifyNewCustomerRegistration;
    }

    /**
     * @param bool $notifyNewCustomerRegistration
     * @return MembershipSettings
     */
    public function setNotifyNewCustomerRegistration(bool $notifyNewCustomerRegistration): MembershipSettings
    {
        $this->notifyNewCustomerRegistration = $notifyNewCustomerRegistration;
        return $this;
    }

    /**
     * @return bool
     */
    public function isPhoneEnabled(): bool
    {
        return $this->phoneEnabled;
    }

    /**
     * @param bool $phoneEnabled
     * @return MembershipSettings
     */
    public function setPhoneEnabled(bool $phoneEnabled): MembershipSettings
    {
        $this->phoneEnabled = $phoneEnabled;
        return $this;
    }

    /**
     * @return bool
     */
    public function isPhoneRequired(): bool
    {
        return $this->phoneRequired;
    }

    /**
     * @param bool $phoneRequired
     * @return MembershipSettings
     */
    public function setPhoneRequired(bool $phoneRequired): MembershipSettings
    {
        $this->phoneRequired = $phoneRequired;
        return $this;
    }



    #endregion properties

}
