<?php


namespace GekTools\Membership;


class RegistrationResult
{

    #region fields

    protected array $errors = array();

    #endregion fields

    #region properties
    /**
     * @return array
     */
    public function getErrors(): array
    {
        return $this->errors;
    }

    /**
     * @param array $errors
     * @return RegistrationResult
     */
    public function setErrors(array $errors): RegistrationResult
    {
        $this->errors = $errors;
        return $this;
    }

    #endregion properties

    #region method

    /**
     * @return bool
     */
    public function isSuccess():bool {
        return empty($this->errors);
    }


    /**
     * @param string $msg
     * @return RegistrationResult
     */
    public function addError(string $msg):self {
        $this->errors[] = $msg;
        return $this;
    }

    #endregion method

}