<?php
namespace GekTools\Membership\Models;

use GekTools\Membership\Entities\UserRole;
use GekTools\Tools\BaseModel;
use CodeIgniter\Database\ConnectionInterface;
use CodeIgniter\Validation\ValidationInterface;

class UserRolesModel extends BaseModel 
{

    #region fields

    protected $table = 'user_roles';

    protected $returnType = UserRole::class;

    protected $primaryKey = 'id';

    protected $useSoftDeletes = false;

    protected $useTimestamps = false;

    protected $allowedFields = [
        'name',
        'systemName',
        'active'
    ];

    protected $validationRules = [
        'name' => 'required|string|max_length[60]',
    ];

    #endregion fields

    #region ctor

    /**
     * 
     * @param ConnectionInterface $db
     * @param ValidationInterface $validation
     */ 
    public function __construct(ConnectionInterface &$db = null, ValidationInterface $validation = null){
        parent::__construct($db, $validation);
    }

    #endregion ctor

}
