<?php
namespace GekTools\Membership\Models;

use GekTools\Membership\Entities\PermissionRecord;
use GekTools\Tools\BaseModel;
use CodeIgniter\Database\ConnectionInterface;
use CodeIgniter\Validation\ValidationInterface;

class PermissionRecordsModel extends BaseModel 
{

    #region fields

    protected $table = 'permission_records';

    protected $returnType = PermissionRecord::class;

    protected $primaryKey = 'id';

    protected $useSoftDeletes = false;

    protected $useTimestamps = false;

    protected $allowedFields = [
        'name',
        'systemName',
        'category',
    ];

    protected $validationRules = [
        'name' => 'required|string|max_length[1000]',
        'category' => 'required|string|max_length[255]',
    ];

    #endregion fields

    #region ctor

    /**
     * 
     * @param ConnectionInterface $db
     * @param ValidationInterface $validation
     */ 
    public function __construct(ConnectionInterface &$db = null, ValidationInterface $validation = null){
        parent::__construct($db, $validation);
    }

    #endregion ctor

}
