<?php
namespace GekTools\Membership\Models;

use GekTools\Membership\Entities\Auth;
use GekTools\Tools\BaseModel;
use CodeIgniter\Database\ConnectionInterface;
use CodeIgniter\Validation\ValidationInterface;

class AuthsModel extends BaseModel
{

    #region fields

    protected $table = 'auths';

    protected $returnType = Auth::class;

    protected $primaryKey = 'id';

    protected $useSoftDeletes = false;

    protected $useTimestamps = true;

    protected $allowedFields = [
        'userGuid',
        'agentString',
        'platform',
        'browser',
        'isMobile',
        'remember',
        'token',
        'ipAddress',
        'expiredDateUtc',
        'createdAtUtc',
        'updatedAtUtc',
    ];

    protected $validationRules = [
        'userGuid' => 'required|string|max_length[36]|min_length[36]|max_length[36]',
        'agentString' => 'required|string|max_length[600]',
        'platform' => 'required|string|max_length[100]',
        'browser' => 'required|string|max_length[100]',
        'token' => 'required|string|max_length[300]',
        'ipAddress' => 'required|string|max_length[100]',
        'expiredDateUtc' => 'required|valid_date[Y-m-d H:i:s]',
    ];

    #endregion fields

    #region ctor

    /**
     *
     * @param ConnectionInterface $db
     * @param ValidationInterface $validation
     */
    public function __construct(ConnectionInterface &$db = null, ValidationInterface $validation = null){
        parent::__construct($db, $validation);
    }

    #endregion ctor

    #region methods

    /**
     * @param string $token
     * @return Auth|null
     */
    public function getByToken(string $token) : ?Auth{
        $fi = Auth::getFieldsInfo();
        /** @var Auth|null $auth */
        $auth =  $this->where($fi->token,$token)
            ->first();
        return $auth;
    }

    #endregion methods

}
