<?php
namespace GekTools\Locale\Models;

use GekTools\Locale\Entities\Language;
use GekTools\Tools\BaseModel;
use CodeIgniter\Database\ConnectionInterface;
use CodeIgniter\Validation\ValidationInterface;

class LanguagesModel extends BaseModel 
{

    #region fields

    protected $table = 'languages';

    protected $returnType = Language::class;

    protected $primaryKey = 'id';

    protected $useSoftDeletes = false;

    protected $useTimestamps = false;

    protected $allowedFields = [
        'name',
        'systemName',
        'culture',
        'uniqueSeoCode',
        'rtl',
        'currencyCode',
        'displayOrder',
        'published',
    ];

    protected $validationRules = [
        'name' => 'required|string|max_length[100]',
        'culture' => 'required|string|max_length[20]',
        'uniqueSeoCode' => 'required|string|max_length[2]',
        'displayOrder' => 'required|integer',
    ];

    #endregion fields

    #region ctor

    /**
     * 
     * @param ConnectionInterface $db
     * @param ValidationInterface $validation
     */ 
    public function __construct(ConnectionInterface &$db = null, ValidationInterface $validation = null){
        parent::__construct($db, $validation);
    }

    #endregion ctor

}
