<?php


namespace GekTools\GenericAttributes\Traits;

use GekTools\GenericAttributes\Entities\GenericAttribute;
use GekTools\GenericAttributes\GenericAttributesService;
use GekTools\Tools\BaseEntity;

/**
 * Trait GenericAttributesTrait
 * @package GekTools\GenericAttributes\Traits
 * @mixin BaseEntity
 */
trait GenericAttributesTrait
{
    protected $genericAttributes = array();

    /**
     * @param string $key
     * @return bool|float|int|mixed|null
     */
    public function getGenericAttributeValue(string $key){
        if(array_key_exists($key,$this->genericAttributes)){
            return $this->genericAttributes[$key];
        }
        /** @var GenericAttributesService $srv */
        $srv = service('genericAttributesService');

        $genAttr = $srv->getByEntityAndKey($this,$key);
        $result = null;
        if($genAttr !== null){
            $result = $genAttr->getRealValue();
            $this->genericAttributes[$key] = $result;
        }
        return $result;

    }

    /**
     * @param string $key
     * @param $value
     * @param bool|null $nullable
     * @param string|null $type
     * @return bool
     * @throws \ReflectionException
     */
    public function setGenericAttributeValue(string $key, $value, ?bool $nullable = null, ?string $type = null):bool {

        /** @var GenericAttributesService $srv */
        $srv = service('genericAttributesService');

        $genAttr = $srv->getByEntityAndKey($this,$key);

        if($genAttr !== null){
            if($nullable === null){
                $nullable = $genAttr->getNullable();
            }
            if(empty($type)){
                $type = $genAttr->getType();
            }
        }else{
            $genAttr = new GenericAttribute();
            $genAttr->setKey($key)
                ->setEntityFullName(get_called_class())
                ->setEntityId($this->getPrimaryKeyValue());
        }
        if(!empty($type)){
            $genAttr->setType($type);
        }
        if($nullable !== null){
            $genAttr->setNullable($nullable);
        }
        $genAttr->setRealValue($value);
        $res = $srv->getModel()->save($genAttr);
        if($res){
            $this->genericAttributes[$key] = $value;
        }
        return $res;
    }
}
