<?php


namespace GekTools\Tools\View;


use GekTools\Tools\Xml\XmlNode;
use GekTools\Tools\Xml\ItoXml;

class Menu implements ItoXml
{

    #region field

    /**
     * @var array|MenuItem[]
     */
    protected array $menuItems = array();

    #endregion field

    #region ctor

    /**
     * Menu constructor.
     * @param array $menuItems
     */
    public function __construct(array $menuItems = array())
    {
        $this->menuItems = $menuItems;
    }



    #endregion ctor

    #region Properties

    /**
     * @return array|MenuItem[]
     */
    public function getMenuItems(): array
    {
        return $this->menuItems;
    }

    /**
     * @param array|MenuItem[] $menuItems
     * @return Menu
     */
    public function setMenuItems(array $menuItems): Menu
    {
        $this->menuItems = $menuItems;
        return $this;
    }

    #endregion Properties

    #region Methods

    public function addMenuItem(MenuItem $menuItem){
        $this->menuItems[] = $menuItem;
    }

    /**
     * @return string
     */
    public function __toString()
    {
        return $this->toXml();
    }

    #endregion Methods

    #region ItoXml

    /**
     * @return XmlNode
     */
    public function toXmlNode(): XmlNode
    {
        $root = new XmlNode('menu');
        $root->isRoot = true;

        foreach ($this->menuItems as $mi){
            $root->addChild($mi->toXmlNode());
        }
        return $root;
    }

    /**
     * @return string
     */
    public function toXml(): string
    {
        return $this->toXmlNode()->toXmlString();
    }

    #endregion ItoXml
}