<?php


namespace GekTools\Tools\Html;


class SelectListItem
{

    #region field

    /**
     * @var string
     */
    protected string $text = '';

    /**
     * @var string|null
     */
    protected ?string $value = null;

    /**
     * @var bool
     */
    protected bool $disabled = false;

    /**
     * @var bool
     */
    protected bool $selected = false;

    /**
     * @var SelectListGroup|null
     */
    protected ?SelectListGroup $group = null;

    #endregion field

    #region ctor

    public function __construct(string $text = '', ?string $value = null, bool $selected = false)
    {
        $this->text = $text;
        $this->value = $value;
        $this->selected = $selected;
    }

    #endregion ctor

    #region Properties

    /**
     * @return string
     */
    public function getText(): string
    {
        return $this->text;
    }

    /**
     * @param string $text
     * @return SelectListItem
     */
    public function setText(string $text): SelectListItem
    {
        $this->text = $text;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getValue(): ?string
    {
        return $this->value;
    }

    /**
     * @param string|null $value
     * @return SelectListItem
     */
    public function setValue(?string $value): SelectListItem
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return bool
     */
    public function isDisabled(): bool
    {
        return $this->disabled;
    }

    /**
     * @param bool $disabled
     * @return SelectListItem
     */
    public function setDisabled(bool $disabled = true): SelectListItem
    {
        $this->disabled = $disabled;
        return $this;
    }

    /**
     * @return bool
     */
    public function isSelected(): bool
    {
        return $this->selected;
    }

    /**
     * @param bool $selected
     * @return SelectListItem
     */
    public function setSelected(bool $selected = true): SelectListItem
    {
        $this->selected = $selected;
        return $this;
    }

    /**
     * @return SelectListGroup|null
     */
    public function getGroup(): ?SelectListGroup
    {
        return $this->group;
    }

    /**
     * @param SelectListGroup|null $group
     * @return SelectListItem
     */
    public function setGroup(?SelectListGroup $group): SelectListItem
    {
        $this->group = $group;
        return $this;
    }

    #endregion Properties

}