<?php


namespace GekTools\Tools\Html;


class SelectListGroup
{

    #region fields

    /**
     * @var string
     */
    protected string $name;

    /**
     * @var bool
     */
    protected bool $disabled = false;

    #endregion fields

    #region ctor

    public function __construct(string $name, bool $disabled = false)
    {
        $this->name = $name;
        $this->disabled = $disabled;
    }

    #endregion ctor

    #region Properties

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return SelectListGroup
     */
    public function setName(string $name): SelectListGroup
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return bool
     */
    public function isDisabled(): bool
    {
        return $this->disabled;
    }

    /**
     * @param bool $disabled
     * @return SelectListGroup
     */
    public function setDisabled(bool $disabled): SelectListGroup
    {
        $this->disabled = $disabled;
        return $this;
    }

    #endregion Properties

}