<?php


namespace GekTools\Tools\Database;



class TableFieldInfo
{
    #region fields

    private string $fieldName;

    private ?string $newName = null;

    private ?DbTypes $dbType = null;

    private ?string $length = null;

    private ?bool $unsigned = null;

    private ?bool $unique = null;

    private $default;

    private bool $nullable = false;

    private bool $autoIncrement = false;

    private ?string $extra = null;

    private ?string $key = null;

    private TableFieldComment $comment;

    private ?string $type = null;

    protected bool $isSetedDefault = false;

    #endregion fields

    #region ctor

    public function __construct(string $fieldName = '')
    {
        $this->fieldName = $fieldName;
        $this->comment = new TableFieldComment();
    }

    #endregion ctor

    #region properties

    /**
     * field name getter
     *
     * @return string
     */
    public function getFieldName(): string
    {
        return $this->fieldName;
    }

    /**
     * field name setter
     *
     * @param string $fieldName
     * @return self
     */
    public function setFieldName(string $fieldName): self
    {
        $this->fieldName = $fieldName;
        return $this;
    }

    /**
     * new name getter
     *
     * @return string|null
     */
    public function getNewName(): ?string
    {
        return $this->newName;
    }

    /**
     * new name setter
     *
     * @param string|null $newName
     * @return self
     */
    public function setNewName(?string $newName): self
    {
        $this->newName = $newName;
        return $this;
    }

    /**
     * newName tanımlı mı
     * @return bool
     */
    public function issetNewName():bool {
        return $this->newName !== null;
    }

    /**
     * database type getter
     *
     * @return DbTypes|null
     */
    public function getDbType(): ?DbTypes
    {
        return $this->dbType;
    }

    /**
     * database type setter
     *
     * @param DbTypes|null $dbType
     * @return self
     */
    public function setDbType(?DbTypes $dbType): self
    {
        $this->dbType = $dbType;
        return $this;
    }

    /**
     * @return bool
     */
    public function issetDbType():bool {
        return $this->dbType !== null;
    }

    /**
     * length getter
     *
     * @return string|null
     */
    public function getLength(): ?string
    {
        return $this->length;
    }

    /**
     * length setter
     *
     * @param string|null $length
     * @return self
     */
    public function setLength(?string $length): self
    {
        $this->length = $length;
        return $this;
    }

    /**
     * length tanımlanmış mı
     *
     * @return bool
     */
    public function issetLength():bool {
        return $this->length !== null;
    }

    /**
     * unsigned getter
     *
     * @return bool|null
     */
    public function getUnsigned(): ?bool
    {
        return $this->unsigned;
    }

    /**
     * unsigned setter
     *
     * @param bool|null $unsigned
     * @return self
     */
    public function setUnsigned(?bool $unsigned): self
    {
        $this->unsigned = $unsigned;
        return $this;
    }

    /**
     * unsigned tanımlı mı ?
     *
     * @return bool
     */
    public function issetUnsigned():bool {
        return $this->unsigned !== null;
    }

    /**
     * unique getter
     *
     * @return bool|null
     */
    public function getUnique(): ?bool
    {
        return $this->unique;
    }

    /**
     * unique setter
     *
     * @param bool|null $unique
     * @return self
     */
    public function setUnique(?bool $unique):self {
        $this->unique = $unique;
        return $this;
    }

    /**
     * unique tanımlı mı
     * @return bool
     */
    public function issetUnique():bool {
        return $this->unique !== null;
    }

    /**
     * default getter
     *
     * @return mixed
     */
    public function getDefault(){
        return $this->default;
    }

    /**
     * default setter
     *
     * @param mixed $default
     * @return self
     */
    public function setDefault($default):self {
        $this->default = $default;
        if($default === null){
            if($this->getNullable()){
                $this->isSetedDefault = true;
            }
        }else{
            $this->isSetedDefault = true;
        }
        return $this;
    }

    public function issetDefault():bool {
        return $this->isSetedDefault;
    }

    /**
     * nullable getter
     *
     * @return bool
     */
    public function getNullable():bool {
        return $this->nullable;
    }

    /**
     * nullable setter
     *
     * @param bool $nullable
     * @return self
     */
    public function setNullable(bool $nullable):self {
        $this->nullable = $nullable;
        if(!$nullable && $this->issetDefault() && $this->default === null){
            $this->isSetedDefault = false;
            unset($this->default);
        }
        return $this;
    }

    /**
     * auto increment getter
     *
     * @return bool
     */
    public function getAutoIncrement():bool {
        return $this->autoIncrement;
    }

    /**
     * autoIncrement setter
     *
     * @param bool $autoIncrement
     * @return self
     */
    public function setAutoIncrement(bool $autoIncrement):self {
        $this->autoIncrement = $autoIncrement;
        return $this;
    }

    /**
     * comment getter
     *
     * @return TableFieldComment|null
     */
    public function getComment():?TableFieldComment{
        return $this->comment;
    }

    /**
     * comment setter
     *
     * @param TableFieldComment|null $comment
     * @return self
     */
    public function setComment(?TableFieldComment $comment):self {
        $this->comment = $comment;
        return $this;
    }

    /**
     * comment tanımlı mı
     *
     * @return bool
     */
    public function issetComment():bool {
        return $this->comment !== null;
    }

    /**
     * @return string|null
     */
    public function getExtra():?string {
        return $this->extra;
    }

    /**
     * @param string|null $extra
     * @return self
     */
    public function setExtra(?string $extra):self {
        $this->extra = $extra;
        return $this;
    }

    /**
     * @return bool
     */
    public function isExtra():bool {
        return $this->extra !== null;
    }

    /**
     * @return string|null
     */
    public function getKey():?string {
        return $this->key;
    }

    /**
     * @param string|null $key
     * @return self
     */
    public function setKey(?string $key):self {
        $this->key = $key;
        return $this;
    }

    /**
     * @return bool
     */
    public function isKey():bool {
        return $this->key !== null;
    }

    /**
     * @return string|null
     */
    public function getType():?string{
        return $this->type;
    }

    /**
     * @param string|null $type
     * @return self
     */
    public function setType(?string $type):self {
        $this->type = $type;
        return $this;
    }

    /**
     * @return bool
     */
    public function isType():bool {
        return $this->type !== null;
    }

    #endregion properties

    #region methods


    #endregion methods
}