<?php
namespace GekTools\Tasks\Models;

use GekTools\Tasks\Entities\ScheduleTask;
use GekTools\Tools\BaseModel;
use CodeIgniter\Database\ConnectionInterface;
use CodeIgniter\Validation\ValidationInterface;

class ScheduleTasksModel extends BaseModel 
{

    #region fields

    protected $table = 'schedule_tasks';

    protected $returnType = ScheduleTask::class;

    protected $primaryKey = 'id';

    protected $useSoftDeletes = false;

    protected $useTimestamps = false;

    protected $allowedFields = [
        'name',
        'seconds',
        'className',
        'enabled',
        'stopOnError',
        'lastStartUtc',
        'lastEndUtc',
        'lastSuccessUtc',
    ];

    protected $validationRules = [
        'name' => 'required|string|max_length[300]',
        'seconds' => 'required|integer|greater_than_equal_to[0]',
        'className' => 'required|string|max_length[300]',
    ];

    #endregion fields

    #region ctor

    /**
     * 
     * @param ConnectionInterface $db
     * @param ValidationInterface $validation
     */ 
    public function __construct(ConnectionInterface &$db = null, ValidationInterface $validation = null){
        parent::__construct($db, $validation);
    }

    #endregion ctor

}
