<?php
namespace GekTools\Settings\Models;

use GekTools\Settings\Entities\Setting;
use GekTools\Tools\BaseModel;
use CodeIgniter\Database\ConnectionInterface;
use CodeIgniter\Validation\ValidationInterface;

class SettingsModel extends BaseModel 
{

    #region fields

    protected $table = 'settings';

    protected $returnType = Setting::class;

    protected $primaryKey = 'id';

    protected $useSoftDeletes = false;

    protected $useTimestamps = true;

    protected $allowedFields = [
        'name',
        'value',
        'type',
        'nullable',
        'createdAtUtc',
        'updatedAtUtc',
    ];

    protected $validationRules = [
        'name' => 'required|string|max_length[300]',
        'type' => 'required|string|max_length[300]',
    ];

    #endregion fields

    #region ctor

    /**
     * 
     * @param ConnectionInterface $db
     * @param ValidationInterface $validation
     */ 
    public function __construct(ConnectionInterface &$db = null, ValidationInterface $validation = null){
        parent::__construct($db, $validation);
    }

    #endregion ctor

}
