<?php
namespace GekTools\Settings\Entities;

use GekTools\Tools\BaseEntity;
use GekTools\Tools\Contrats\ICreatedAtUtc;
use GekTools\Tools\Contrats\IUpdatedAtUtc;
use GekTools\Settings\Entities\Extensions\SettingTrait;
use CodeIgniter\I18n\Time;

class Setting extends BaseEntity implements ICreatedAtUtc, IUpdatedAtUtc 
{

    use SettingTrait;

    #region fields

    protected $attributes = [
        'id' => null,
        'name' => null,
        'value' => null,
        'type' => null,
        'nullable' => 0,
        'createdAtUtc' => null,
        'updatedAtUtc' => null,
    ];

    protected $defaultValues = [
        'id' => 0,
        'name' => '',
        'value' => null,
        'type' => '',
        'nullable' => 0,
        'createdAtUtc' => '0000-00-00 00:00:00',
        'updatedAtUtc' => null,
    ];

    protected $datamap = [];

    protected $casts = [
        'id' => 'int',
        'name' => 'string',
        'value' => '?string',
        'type' => 'string',
        'nullable' => 'bool',
        'createdAtUtc' => 'CodeIgniter\I18n\Time',
        'updatedAtUtc' => '?CodeIgniter\I18n\Time',
    ];

    #endregion fields

    #region properties

    /**
     * id getter

     * 
     * @return int|null
     * @throws \Exception
     */ 
    public function getId():?int {
        $_attrKey = $this->mapProperty('id');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'int');
        return $result;
    }

    /**
     * name getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getName():?string {
        $_attrKey = $this->mapProperty('name');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * name setter

     * 
     * @param string $name
     * @return self
     */ 
    public function setName(string $name):self {
        $_attrKey = $this->mapProperty('name');
        $this->attributes[$_attrKey] = $name;
        return $this;
    }

    /**
     * value getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getValue():?string {
        $_attrKey = $this->mapProperty('value');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?string');
        return $result;
    }

    /**
     * value setter

     * 
     * @param string|null $value
     * @return self
     */ 
    public function setValue(?string $value):self {
        $_attrKey = $this->mapProperty('value');
        $this->attributes[$_attrKey] = $value;
        return $this;
    }

    /**
     * type getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getType():?string {
        $_attrKey = $this->mapProperty('type');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * type setter

     * 
     * @param string $type
     * @return self
     */ 
    public function setType(string $type):self {
        $_attrKey = $this->mapProperty('type');
        $this->attributes[$_attrKey] = $type;
        return $this;
    }

    /**
     * nullable getter

     * 
     * @return bool|null
     * @throws \Exception
     */ 
    public function getNullable():?bool {
        $_attrKey = $this->mapProperty('nullable');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'bool');
        return $result;
    }

    /**
     * nullable setter

     * 
     * @param bool $nullable
     * @return self
     */ 
    public function setNullable(bool $nullable):self {
        $_attrKey = $this->mapProperty('nullable');
        $this->attributes[$_attrKey] = $nullable;
        return $this;
    }

    /**
     * createdAtUtc getter

     * 
     * @return Time|null
     * @throws \Exception
     */ 
    public function getCreatedAtUtc():?Time {
        $_attrKey = $this->mapProperty('createdAtUtc');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'CodeIgniter\I18n\Time');
        return $result;
    }

    /**
     * updatedAtUtc getter

     * 
     * @return Time|null
     * @throws \Exception
     */ 
    public function getUpdatedAtUtc():?Time {
        $_attrKey = $this->mapProperty('updatedAtUtc');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?CodeIgniter\I18n\Time');
        return $result;
    }

    #endregion properties

    #region statics

    /**
     * get db Fields info

     * 
     * @return SettingFieldsInfo
     */ 
    public static function getFieldsInfo():SettingFieldsInfo {
        static $fInfo = null;
        if($fInfo == null){
            $fInfo = new SettingFieldsInfo();
        }
        return $fInfo;
    }

    #endregion statics

}


class SettingFieldsInfo 
{

    /**
     * 
     * @var string
     */ 
    public string $id = 'id';

    /**
     * 
     * @var string
     */ 
    public string $name = 'name';

    /**
     * 
     * @var string
     */ 
    public string $value = 'value';

    /**
     * 
     * @var string
     */ 
    public string $type = 'type';

    /**
     * 
     * @var string
     */ 
    public string $nullable = 'nullable';

    /**
     * 
     * @var string
     */ 
    public string $createdAtUtc = 'createdAtUtc';

    /**
     * 
     * @var string
     */ 
    public string $updatedAtUtc = 'updatedAtUtc';

}
