<?php
namespace GekTools\Membership\Models;

use GekTools\Membership\Entities\User;
use GekTools\Tools\BaseModel;
use CodeIgniter\Database\ConnectionInterface;
use CodeIgniter\Validation\ValidationInterface;

class UsersModel extends BaseModel 
{

    #region fields

    protected $table = 'users';

    protected $returnType = User::class;

    protected $primaryKey = 'id';

    protected $useSoftDeletes = true;

    protected $useTimestamps = true;

    protected $allowedFields = [
        'userGuid',
        'name',
        'lastName',
        'email',
        'userName',
        'phone',
        'passwordHash',
        'passwordFormat',
        'adminNotes',
        'systemAccount',
        'systemName',
        'lastIp',
        'status',
        'lastLoginDateUtc',
        'lastActivityDataUtc',
        'createdAtUtc',
        'updatedAtUtc',
        'deletedAtUtc',
    ];

    protected $validationRules = [

    ];

    #endregion fields

    #region ctor

    /**
     * 
     * @param ConnectionInterface $db
     * @param ValidationInterface $validation
     */ 
    public function __construct(ConnectionInterface &$db = null, ValidationInterface $validation = null){
        parent::__construct($db, $validation);
    }

    #endregion ctor

}
