<?php
namespace GekTools\Membership\Entities;

use GekTools\Tools\BaseEntity;
use GekTools\Tools\Contrats\ISystemName;
use GekTools\Tools\Contrats\ICreatedAtUtc;
use GekTools\Tools\Contrats\IUpdatedAtUtc;
use GekTools\Tools\Contrats\ISoftDeletable;
use GekTools\Membership\Entities\Extensions\UserTrait;
use GekTools\Membership\PasswordFormat;
use GekTools\Membership\UserStatus;
use CodeIgniter\I18n\Time;

class User extends BaseEntity implements ISystemName, ICreatedAtUtc, IUpdatedAtUtc, ISoftDeletable 
{

    use UserTrait;

    #region fields

    protected $attributes = [
        'id' => null,
        'userGuid' => null,
        'name' => null,
        'lastName' => null,
        'email' => null,
        'userName' => null,
        'phone' => null,
        'passwordHash' => null,
        'passwordFormat' => 1,
        'adminNotes' => null,
        'systemAccount' => 0,
        'systemName' => null,
        'lastIp' => null,
        'status' => 3,
        'lastLoginDateUtc' => null,
        'lastActivityDataUtc' => null,
        'createdAtUtc' => null,
        'updatedAtUtc' => null,
        'deletedAtUtc' => null,
    ];

    protected $defaultValues = [
        'id' => 0,
        'userGuid' => '',
        'name' => null,
        'lastName' => null,
        'email' => '',
        'userName' => null,
        'phone' => null,
        'passwordHash' => null,
        'passwordFormat' => 1,
        'adminNotes' => null,
        'systemAccount' => 0,
        'systemName' => null,
        'lastIp' => '',
        'status' => 3,
        'lastLoginDateUtc' => null,
        'lastActivityDataUtc' => null,
        'createdAtUtc' => '0000-00-00 00:00:00',
        'updatedAtUtc' => null,
        'deletedAtUtc' => null,
    ];

    protected $datamap = [];

    protected $casts = [
        'id' => 'int',
        'userGuid' => 'string',
        'name' => '?string',
        'lastName' => '?string',
        'email' => 'string',
        'userName' => '?string',
        'phone' => '?string',
        'passwordHash' => '?string',
        'passwordFormat' => 'GekTools\Membership\PasswordFormat',
        'adminNotes' => '?string',
        'systemAccount' => 'bool',
        'systemName' => '?string',
        'lastIp' => 'string',
        'status' => 'GekTools\Membership\UserStatus',
        'lastLoginDateUtc' => '?CodeIgniter\I18n\Time',
        'lastActivityDataUtc' => '?CodeIgniter\I18n\Time',
        'createdAtUtc' => 'CodeIgniter\I18n\Time',
        'updatedAtUtc' => '?CodeIgniter\I18n\Time',
        'deletedAtUtc' => '?CodeIgniter\I18n\Time',
    ];

    #endregion fields

    #region properties

    /**
     * id getter

     * 
     * @return int|null
     * @throws \Exception
     */ 
    public function getId():?int {
        $_attrKey = $this->mapProperty('id');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'int');
        return $result;
    }

    /**
     * userGuid getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getUserGuid():?string {
        $_attrKey = $this->mapProperty('userGuid');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * userGuid setter

     * 
     * @param string $userGuid
     * @return self
     */ 
    public function setUserGuid(string $userGuid):self {
        $_attrKey = $this->mapProperty('userGuid');
        $this->attributes[$_attrKey] = $userGuid;
        return $this;
    }

    /**
     * name getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getName():?string {
        $_attrKey = $this->mapProperty('name');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?string');
        return $result;
    }

    /**
     * name setter

     * 
     * @param string|null $name
     * @return self
     */ 
    public function setName(?string $name):self {
        $_attrKey = $this->mapProperty('name');
        $this->attributes[$_attrKey] = $name;
        return $this;
    }

    /**
     * lastName getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getLastName():?string {
        $_attrKey = $this->mapProperty('lastName');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?string');
        return $result;
    }

    /**
     * lastName setter

     * 
     * @param string|null $lastName
     * @return self
     */ 
    public function setLastName(?string $lastName):self {
        $_attrKey = $this->mapProperty('lastName');
        $this->attributes[$_attrKey] = $lastName;
        return $this;
    }

    /**
     * email getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getEmail():?string {
        $_attrKey = $this->mapProperty('email');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * email setter

     * 
     * @param string $email
     * @return self
     */ 
    public function setEmail(string $email):self {
        $_attrKey = $this->mapProperty('email');
        $this->attributes[$_attrKey] = $email;
        return $this;
    }

    /**
     * userName getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getUserName():?string {
        $_attrKey = $this->mapProperty('userName');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?string');
        return $result;
    }

    /**
     * userName setter

     * 
     * @param string|null $userName
     * @return self
     */ 
    public function setUserName(?string $userName):self {
        $_attrKey = $this->mapProperty('userName');
        $this->attributes[$_attrKey] = $userName;
        return $this;
    }

    /**
     * phone getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getPhone():?string {
        $_attrKey = $this->mapProperty('phone');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?string');
        return $result;
    }

    /**
     * phone setter

     * 
     * @param string|null $phone
     * @return self
     */ 
    public function setPhone(?string $phone):self {
        $_attrKey = $this->mapProperty('phone');
        $this->attributes[$_attrKey] = $phone;
        return $this;
    }

    /**
     * passwordHash getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getPasswordHash():?string {
        $_attrKey = $this->mapProperty('passwordHash');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?string');
        return $result;
    }

    /**
     * passwordHash setter

     * 
     * @param string|null $passwordHash
     * @return self
     */ 
    public function setPasswordHash(?string $passwordHash):self {
        $_attrKey = $this->mapProperty('passwordHash');
        $this->attributes[$_attrKey] = $passwordHash;
        return $this;
    }

    /**
     * passwordFormat getter

     * 
     * @return PasswordFormat|null
     * @throws \Exception
     */ 
    public function getPasswordFormat():?PasswordFormat {
        $_attrKey = $this->mapProperty('passwordFormat');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'GekTools\Membership\PasswordFormat');
        return $result;
    }

    /**
     * passwordFormat setter

     * 
     * @param PasswordFormat $passwordFormat
     * @return self
     */ 
    public function setPasswordFormat(PasswordFormat $passwordFormat):self {
        $_attrKey = $this->mapProperty('passwordFormat');
        $this->attributes[$_attrKey] = $passwordFormat;
        return $this;
    }

    /**
     * adminNotes getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getAdminNotes():?string {
        $_attrKey = $this->mapProperty('adminNotes');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?string');
        return $result;
    }

    /**
     * adminNotes setter

     * 
     * @param string|null $adminNotes
     * @return self
     */ 
    public function setAdminNotes(?string $adminNotes):self {
        $_attrKey = $this->mapProperty('adminNotes');
        $this->attributes[$_attrKey] = $adminNotes;
        return $this;
    }

    /**
     * systemAccount getter

     * 
     * @return bool|null
     * @throws \Exception
     */ 
    public function getSystemAccount():?bool {
        $_attrKey = $this->mapProperty('systemAccount');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'bool');
        return $result;
    }

    /**
     * systemAccount setter

     * 
     * @param bool $systemAccount
     * @return self
     */ 
    public function setSystemAccount(bool $systemAccount):self {
        $_attrKey = $this->mapProperty('systemAccount');
        $this->attributes[$_attrKey] = $systemAccount;
        return $this;
    }

    /**
     * systemName getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getSystemName():?string {
        $_attrKey = $this->mapProperty('systemName');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?string');
        return $result;
    }

    /**
     * systemName setter

     * 
     * @param string|null $systemName
     * @return self
     */ 
    public function setSystemName(?string $systemName):self {
        $_attrKey = $this->mapProperty('systemName');
        $this->attributes[$_attrKey] = $systemName;
        return $this;
    }

    /**
     * lastIp getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getLastIp():?string {
        $_attrKey = $this->mapProperty('lastIp');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * lastIp setter

     * 
     * @param string $lastIp
     * @return self
     */ 
    public function setLastIp(string $lastIp):self {
        $_attrKey = $this->mapProperty('lastIp');
        $this->attributes[$_attrKey] = $lastIp;
        return $this;
    }

    /**
     * status getter

     * 
     * @return UserStatus|null
     * @throws \Exception
     */ 
    public function getStatus():?UserStatus {
        $_attrKey = $this->mapProperty('status');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'GekTools\Membership\UserStatus');
        return $result;
    }

    /**
     * status setter

     * 
     * @param UserStatus $status
     * @return self
     */ 
    public function setStatus(UserStatus $status):self {
        $_attrKey = $this->mapProperty('status');
        $this->attributes[$_attrKey] = $status;
        return $this;
    }

    /**
     * lastLoginDateUtc getter

     * 
     * @return Time|null
     * @throws \Exception
     */ 
    public function getLastLoginDateUtc():?Time {
        $_attrKey = $this->mapProperty('lastLoginDateUtc');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?CodeIgniter\I18n\Time');
        return $result;
    }

    /**
     * lastLoginDateUtc setter

     * 
     * @param Time|null $lastLoginDateUtc
     * @return self
     */ 
    public function setLastLoginDateUtc(?Time $lastLoginDateUtc):self {
        $_attrKey = $this->mapProperty('lastLoginDateUtc');
        $this->attributes[$_attrKey] = $lastLoginDateUtc;
        return $this;
    }

    /**
     * lastActivityDataUtc getter

     * 
     * @return Time|null
     * @throws \Exception
     */ 
    public function getLastActivityDataUtc():?Time {
        $_attrKey = $this->mapProperty('lastActivityDataUtc');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?CodeIgniter\I18n\Time');
        return $result;
    }

    /**
     * lastActivityDataUtc setter

     * 
     * @param Time|null $lastActivityDataUtc
     * @return self
     */ 
    public function setLastActivityDataUtc(?Time $lastActivityDataUtc):self {
        $_attrKey = $this->mapProperty('lastActivityDataUtc');
        $this->attributes[$_attrKey] = $lastActivityDataUtc;
        return $this;
    }

    /**
     * createdAtUtc getter

     * 
     * @return Time|null
     * @throws \Exception
     */ 
    public function getCreatedAtUtc():?Time {
        $_attrKey = $this->mapProperty('createdAtUtc');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'CodeIgniter\I18n\Time');
        return $result;
    }

    /**
     * updatedAtUtc getter

     * 
     * @return Time|null
     * @throws \Exception
     */ 
    public function getUpdatedAtUtc():?Time {
        $_attrKey = $this->mapProperty('updatedAtUtc');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?CodeIgniter\I18n\Time');
        return $result;
    }

    /**
     * deletedAtUtc getter

     * 
     * @return Time|null
     * @throws \Exception
     */ 
    public function getDeletedAtUtc():?Time {
        $_attrKey = $this->mapProperty('deletedAtUtc');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?CodeIgniter\I18n\Time');
        return $result;
    }

    #endregion properties

    #region statics

    /**
     * get db Fields info

     * 
     * @return UserFieldsInfo
     */ 
    public static function getFieldsInfo():UserFieldsInfo {
        static $fInfo = null;
        if($fInfo == null){
            $fInfo = new UserFieldsInfo();
        }
        return $fInfo;
    }

    #endregion statics

}


class UserFieldsInfo 
{

    /**
     * 
     * @var string
     */ 
    public string $id = 'id';

    /**
     * 
     * @var string
     */ 
    public string $userGuid = 'userGuid';

    /**
     * 
     * @var string
     */ 
    public string $name = 'name';

    /**
     * 
     * @var string
     */ 
    public string $lastName = 'lastName';

    /**
     * 
     * @var string
     */ 
    public string $email = 'email';

    /**
     * 
     * @var string
     */ 
    public string $userName = 'userName';

    /**
     * 
     * @var string
     */ 
    public string $phone = 'phone';

    /**
     * 
     * @var string
     */ 
    public string $passwordHash = 'passwordHash';

    /**
     * 
     * @var string
     */ 
    public string $passwordFormat = 'passwordFormat';

    /**
     * 
     * @var string
     */ 
    public string $adminNotes = 'adminNotes';

    /**
     * 
     * @var string
     */ 
    public string $systemAccount = 'systemAccount';

    /**
     * 
     * @var string
     */ 
    public string $systemName = 'systemName';

    /**
     * 
     * @var string
     */ 
    public string $lastIp = 'lastIp';

    /**
     * 
     * @var string
     */ 
    public string $status = 'status';

    /**
     * 
     * @var string
     */ 
    public string $lastLoginDateUtc = 'lastLoginDateUtc';

    /**
     * 
     * @var string
     */ 
    public string $lastActivityDataUtc = 'lastActivityDataUtc';

    /**
     * 
     * @var string
     */ 
    public string $createdAtUtc = 'createdAtUtc';

    /**
     * 
     * @var string
     */ 
    public string $updatedAtUtc = 'updatedAtUtc';

    /**
     * 
     * @var string
     */ 
    public string $deletedAtUtc = 'deletedAtUtc';

}
