<?php
namespace GekTools\Membership\Entities;

use GekTools\Tools\BaseEntity;
use GekTools\Tools\Contrats\ISystemName;
use GekTools\Membership\Entities\Extensions\PermissionRecordTrait;

class PermissionRecord extends BaseEntity implements ISystemName 
{

    use PermissionRecordTrait;

    #region fields

    protected $attributes = [
        'id' => null,
        'name' => null,
        'systemName' => null,
        'category' => null,
    ];

    protected $defaultValues = [
        'id' => 0,
        'name' => '',
        'systemName' => null,
        'category' => '',
    ];

    protected $datamap = [];

    protected $casts = [
        'id' => 'int',
        'name' => 'string',
        'systemName' => '?string',
        'category' => 'string',
    ];

    #endregion fields

    #region properties

    /**
     * id getter

     * 
     * @return int|null
     * @throws \Exception
     */ 
    public function getId():?int {
        $_attrKey = $this->mapProperty('id');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'int');
        return $result;
    }

    /**
     * name getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getName():?string {
        $_attrKey = $this->mapProperty('name');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * name setter

     * 
     * @param string $name
     * @return self
     */ 
    public function setName(string $name):self {
        $_attrKey = $this->mapProperty('name');
        $this->attributes[$_attrKey] = $name;
        return $this;
    }

    /**
     * systemName getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getSystemName():?string {
        $_attrKey = $this->mapProperty('systemName');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?string');
        return $result;
    }

    /**
     * systemName setter

     * 
     * @param string|null $systemName
     * @return self
     */ 
    public function setSystemName(?string $systemName):self {
        $_attrKey = $this->mapProperty('systemName');
        $this->attributes[$_attrKey] = $systemName;
        return $this;
    }

    /**
     * category getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getCategory():?string {
        $_attrKey = $this->mapProperty('category');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * category setter

     * 
     * @param string $category
     * @return self
     */ 
    public function setCategory(string $category):self {
        $_attrKey = $this->mapProperty('category');
        $this->attributes[$_attrKey] = $category;
        return $this;
    }

    #endregion properties

    #region statics

    /**
     * get db Fields info

     * 
     * @return PermissionRecordFieldsInfo
     */ 
    public static function getFieldsInfo():PermissionRecordFieldsInfo {
        static $fInfo = null;
        if($fInfo == null){
            $fInfo = new PermissionRecordFieldsInfo();
        }
        return $fInfo;
    }

    #endregion statics

}


class PermissionRecordFieldsInfo 
{

    /**
     * 
     * @var string
     */ 
    public string $id = 'id';

    /**
     * 
     * @var string
     */ 
    public string $name = 'name';

    /**
     * 
     * @var string
     */ 
    public string $systemName = 'systemName';

    /**
     * 
     * @var string
     */ 
    public string $category = 'category';

}
