<?php

namespace GekTools\Membership\Entities\Extensions;


use GekTools\Membership\Entities\Auth;

/**
 * Trait AuthTrait
 * @mixin Auth
 */
trait AuthTrait
{

    public function toRawArray(bool $onlyChanged = false): array
    {
        $res = parent::toRawArray($onlyChanged);
        if($onlyChanged){
            $fi = static::getFieldsInfo();
            if(!isset($res[$fi->token])){
                $res[$fi->token] = $this->attributes[$fi->token];
            }
        }
        return $res;
    }

}
