<?php
namespace GekTools\Membership\Entities;

use GekTools\Tools\BaseEntity;
use GekTools\Tools\Contrats\ICreatedAtUtc;
use GekTools\Tools\Contrats\IUpdatedAtUtc;
use GekTools\Membership\Entities\Extensions\AuthTrait;
use CodeIgniter\I18n\Time;

class Auth extends BaseEntity implements ICreatedAtUtc, IUpdatedAtUtc 
{

    use AuthTrait;

    #region fields

    protected $attributes = [
        'id' => null,
        'userGuid' => null,
        'agentString' => null,
        'platform' => null,
        'browser' => null,
        'isMobile' => 0,
        'remember' => 0,
        'token' => null,
        'ipAddress' => null,
        'expiredDateUtc' => null,
        'createdAtUtc' => null,
        'updatedAtUtc' => null,
    ];

    protected $defaultValues = [
        'id' => 0,
        'userGuid' => '',
        'agentString' => '',
        'platform' => '',
        'browser' => '',
        'isMobile' => 0,
        'remember' => 0,
        'token' => '',
        'ipAddress' => '',
        'expiredDateUtc' => '0000-00-00 00:00:00',
        'createdAtUtc' => '0000-00-00 00:00:00',
        'updatedAtUtc' => null,
    ];

    protected $datamap = [];

    protected $casts = [
        'id' => 'int',
        'userGuid' => 'string',
        'agentString' => 'string',
        'platform' => 'string',
        'browser' => 'string',
        'isMobile' => 'bool',
        'remember' => 'bool',
        'token' => 'string',
        'ipAddress' => 'string',
        'expiredDateUtc' => 'CodeIgniter\I18n\Time',
        'createdAtUtc' => 'CodeIgniter\I18n\Time',
        'updatedAtUtc' => '?CodeIgniter\I18n\Time',
    ];

    #endregion fields

    #region properties

    /**
     * id getter

     * 
     * @return int|null
     * @throws \Exception
     */ 
    public function getId():?int {
        $_attrKey = $this->mapProperty('id');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'int');
        return $result;
    }

    /**
     * userGuid getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getUserGuid():?string {
        $_attrKey = $this->mapProperty('userGuid');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * userGuid setter

     * 
     * @param string $userGuid
     * @return self
     */ 
    public function setUserGuid(string $userGuid):self {
        $_attrKey = $this->mapProperty('userGuid');
        $this->attributes[$_attrKey] = $userGuid;
        return $this;
    }

    /**
     * agentString getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getAgentString():?string {
        $_attrKey = $this->mapProperty('agentString');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * agentString setter

     * 
     * @param string $agentString
     * @return self
     */ 
    public function setAgentString(string $agentString):self {
        $_attrKey = $this->mapProperty('agentString');
        $this->attributes[$_attrKey] = $agentString;
        return $this;
    }

    /**
     * platform getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getPlatform():?string {
        $_attrKey = $this->mapProperty('platform');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * platform setter

     * 
     * @param string $platform
     * @return self
     */ 
    public function setPlatform(string $platform):self {
        $_attrKey = $this->mapProperty('platform');
        $this->attributes[$_attrKey] = $platform;
        return $this;
    }

    /**
     * browser getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getBrowser():?string {
        $_attrKey = $this->mapProperty('browser');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * browser setter

     * 
     * @param string $browser
     * @return self
     */ 
    public function setBrowser(string $browser):self {
        $_attrKey = $this->mapProperty('browser');
        $this->attributes[$_attrKey] = $browser;
        return $this;
    }

    /**
     * isMobile getter

     * 
     * @return bool|null
     * @throws \Exception
     */ 
    public function getIsMobile():?bool {
        $_attrKey = $this->mapProperty('isMobile');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'bool');
        return $result;
    }

    /**
     * isMobile setter

     * 
     * @param bool $isMobile
     * @return self
     */ 
    public function setIsMobile(bool $isMobile):self {
        $_attrKey = $this->mapProperty('isMobile');
        $this->attributes[$_attrKey] = $isMobile;
        return $this;
    }

    /**
     * remember getter

     * 
     * @return bool|null
     * @throws \Exception
     */ 
    public function getRemember():?bool {
        $_attrKey = $this->mapProperty('remember');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'bool');
        return $result;
    }

    /**
     * remember setter

     * 
     * @param bool $remember
     * @return self
     */ 
    public function setRemember(bool $remember):self {
        $_attrKey = $this->mapProperty('remember');
        $this->attributes[$_attrKey] = $remember;
        return $this;
    }

    /**
     * token getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getToken():?string {
        $_attrKey = $this->mapProperty('token');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * token setter

     * 
     * @param string $token
     * @return self
     */ 
    public function setToken(string $token):self {
        $_attrKey = $this->mapProperty('token');
        $this->attributes[$_attrKey] = $token;
        return $this;
    }

    /**
     * ipAddress getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getIpAddress():?string {
        $_attrKey = $this->mapProperty('ipAddress');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * ipAddress setter

     * 
     * @param string $ipAddress
     * @return self
     */ 
    public function setIpAddress(string $ipAddress):self {
        $_attrKey = $this->mapProperty('ipAddress');
        $this->attributes[$_attrKey] = $ipAddress;
        return $this;
    }

    /**
     * expiredDateUtc getter

     * 
     * @return Time|null
     * @throws \Exception
     */ 
    public function getExpiredDateUtc():?Time {
        $_attrKey = $this->mapProperty('expiredDateUtc');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'CodeIgniter\I18n\Time');
        return $result;
    }

    /**
     * expiredDateUtc setter

     * 
     * @param Time $expiredDateUtc
     * @return self
     */ 
    public function setExpiredDateUtc(Time $expiredDateUtc):self {
        $_attrKey = $this->mapProperty('expiredDateUtc');
        $this->attributes[$_attrKey] = $expiredDateUtc;
        return $this;
    }

    /**
     * createdAtUtc getter

     * 
     * @return Time|null
     * @throws \Exception
     */ 
    public function getCreatedAtUtc():?Time {
        $_attrKey = $this->mapProperty('createdAtUtc');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'CodeIgniter\I18n\Time');
        return $result;
    }

    /**
     * updatedAtUtc getter

     * 
     * @return Time|null
     * @throws \Exception
     */ 
    public function getUpdatedAtUtc():?Time {
        $_attrKey = $this->mapProperty('updatedAtUtc');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?CodeIgniter\I18n\Time');
        return $result;
    }

    #endregion properties

    #region statics

    /**
     * get db Fields info

     * 
     * @return AuthFieldsInfo
     */ 
    public static function getFieldsInfo():AuthFieldsInfo {
        static $fInfo = null;
        if($fInfo == null){
            $fInfo = new AuthFieldsInfo();
        }
        return $fInfo;
    }

    #endregion statics

}


class AuthFieldsInfo 
{

    /**
     * 
     * @var string
     */ 
    public string $id = 'id';

    /**
     * 
     * @var string
     */ 
    public string $userGuid = 'userGuid';

    /**
     * 
     * @var string
     */ 
    public string $agentString = 'agentString';

    /**
     * 
     * @var string
     */ 
    public string $platform = 'platform';

    /**
     * 
     * @var string
     */ 
    public string $browser = 'browser';

    /**
     * 
     * @var string
     */ 
    public string $isMobile = 'isMobile';

    /**
     * 
     * @var string
     */ 
    public string $remember = 'remember';

    /**
     * 
     * @var string
     */ 
    public string $token = 'token';

    /**
     * 
     * @var string
     */ 
    public string $ipAddress = 'ipAddress';

    /**
     * 
     * @var string
     */ 
    public string $expiredDateUtc = 'expiredDateUtc';

    /**
     * 
     * @var string
     */ 
    public string $createdAtUtc = 'createdAtUtc';

    /**
     * 
     * @var string
     */ 
    public string $updatedAtUtc = 'updatedAtUtc';

}
