<?php


namespace GekTools\Membership\Database\Seeds;



use CodeIgniter\Database\Seeder;
use GekTools\Membership\PasswordFormat;
use GekTools\Membership\SystemRoleNames;
use GekTools\Membership\SystemUserNames;
use GekTools\Membership\UserStatus;
use GekTools\Tools\Guid;

class UserSeeds extends Seeder
{

    public function run()
    {
        $data = array(
            'userGuid' => Guid::create(),
            'name' => 'Atakan',
            'lastName' => 'Çalışkan',
            'email' => 'atakan2caliskan@gmail.com',
            'userName' => 'atakan',
            'phone' => null,
            'passwordHash' => md5('powerpc@1643'),
            'passwordFormat' => PasswordFormat::MD5,
            'adminNotes' => null,
            'systemAccount' => false,
            'systemName' => null,
            'lastIp' => '::1',
            'status' => UserStatus::ACTIVE,
            'lastLoginDateUtc' => null,
            'lastActivityDataUtc' => null,
            'createdAtUtc' => gmdate('Y-m-d H:i:s'),
            'updatedAtUtc' => null,
            'deletedAtUtc' => null,
        );
        $this->db->table('users')->insert($data);

        $data = array(
            'userGuid' => Guid::create(),
            'name' => 'Süleyman',
            'lastName' => 'Efe',
            'email' => 'suleyman.efe@live.com',
            'userName' => 'suleyman',
            'phone' => null,
            'passwordHash' => md5('1907fenerli-*-*'),
            'passwordFormat' => PasswordFormat::MD5,
            'adminNotes' => null,
            'systemAccount' => false,
            'systemName' => null,
            'lastIp' => '::1',
            'status' => UserStatus::ACTIVE,
            'lastLoginDateUtc' => null,
            'lastActivityDataUtc' => null,
            'createdAtUtc' => gmdate('Y-m-d H:i:s'),
            'updatedAtUtc' => null,
            'deletedAtUtc' => null,
        );
        $this->db->table('users')->insert($data);

        $data = array(
            'userGuid' => Guid::create(),
            'name' => null,
            'lastName' => null,
            'email' => 'builtin@background_task.com',
            'userName' => 'builtin@background_task.com',
            'phone' => null,
            'passwordHash' => null,
            'passwordFormat' => PasswordFormat::MD5,
            'adminNotes' => 'Arka plan görevleri için kullanılan yerleşik kullanıcı.',
            'systemAccount' => true,
            'systemName' => SystemUserNames::BACKGROUND_TASK,
            'lastIp' => '::1',
            'status' => UserStatus::ACTIVE,
            'lastLoginDateUtc' => null,
            'lastActivityDataUtc' => null,
            'createdAtUtc' => gmdate('Y-m-d H:i:s'),
            'updatedAtUtc' => null,
            'deletedAtUtc' => null,
        );
        $this->db->table('users')->insert($data);

        $data = array(
            'userGuid' => Guid::create(),
            'name' => null,
            'lastName' => null,
            'email' => 'builtin@search_engine.com',
            'userName' => 'builtin@search_engine.com',
            'phone' => null,
            'passwordHash' => null,
            'passwordFormat' => PasswordFormat::MD5,
            'adminNotes' => 'Yerleşik misafir kullanıcısı, arama motorlarından gelen istekler için kullanılır.',
            'systemAccount' => true,
            'systemName' => SystemUserNames::SEARCH_ENGINE,
            'lastIp' => '::1',
            'status' => UserStatus::ACTIVE,
            'lastLoginDateUtc' => null,
            'lastActivityDataUtc' => null,
            'createdAtUtc' => gmdate('Y-m-d H:i:s'),
            'updatedAtUtc' => null,
            'deletedAtUtc' => null,
        );
        $this->db->table('users')->insert($data);

        $atakan = $this->db->table('users')->where('userName','atakan')->get()->getRow(0);
        $suleyman = $this->db->table('users')->where('userName','suleyman')->get()->getRow(0);
        $background_task = $this->db->table('users')->where('systemName',SystemUserNames::BACKGROUND_TASK)->get()->getRow(0);
        $search_engine = $this->db->table('users')->where('systemName',SystemUserNames::SEARCH_ENGINE)->get()->getRow(0);

        $system_admin = $this->db->table('user_roles')->where('systemName',SystemRoleNames::SYSTEM_ADMIN)->get()->getRow(0);
        $admin = $this->db->table('user_roles')->where('systemName',SystemRoleNames::ADMINISTARATORS)->get()->getRow(0);
        $registered = $this->db->table('user_roles')->where('systemName',SystemRoleNames::REGISTERED)->get()->getRow(0);
        $guest = $this->db->table('user_roles')->where('systemName',SystemRoleNames::GUESTS)->get()->getRow(0);

        $data = array(
            'userId' => $atakan->id,
            'roleId' => $system_admin->id,
        );
        $this->db->table('user_role_mappings')->insert($data);

        $data = array(
            'userId' => $atakan->id,
            'roleId' => $admin->id,
        );
        $this->db->table('user_role_mappings')->insert($data);


        $data = array(
            'userId' => $atakan->id,
            'roleId' => $registered->id,
        );
        $this->db->table('user_role_mappings')->insert($data);

        $data = array(
            'userId' => $suleyman->id,
            'roleId' => $system_admin->id,
        );
        $this->db->table('user_role_mappings')->insert($data);


        $data = array(
            'userId' => $suleyman->id,
            'roleId' => $admin->id,
        );
        $this->db->table('user_role_mappings')->insert($data);

        $data = array(
            'userId' => $suleyman->id,
            'roleId' => $registered->id,
        );
        $this->db->table('user_role_mappings')->insert($data);

        $data = array(
            'userId' => $background_task->id,
            'roleId' => $guest->id,
        );
        $this->db->table('user_role_mappings')->insert($data);

        $data = array(
            'userId' => $search_engine->id,
            'roleId' => $guest->id,
        );
        $this->db->table('user_role_mappings')->insert($data);

    }
}
