<?php 

namespace GekTools\Membership\Database\Migrations;

use CodeIgniter\Database\Migration;
use GekTools\Tools\Traits\MigrationTrait;

class CreatePermissionRoleMappings extends Migration 
{

    use MigrationTrait;

    protected string $tableName = 'permission_role_mappings';

    protected string $pkName = 'id';

    public function up(){
        $this->entityName = 'PermissionRoleMap';
        $this->namespace = 'GekTools\\Membership';
        $this->addPrimaryKeyField($this->pkName);

        $this->addIntField('permissionRecordId',false,true)
            ->addKey('permissionRecordId',true)
            ->addIntField('userRoleId',false,true)
            ->addKey('userRoleId',true);

        $this->createTable($this->tableName);
    }

    public function down(){
        $this->forge->dropTable($this->tableName);
    }

}
