<?php
namespace GekTools\Locale\Models;

use GekTools\Locale\Entities\LocalizedProperty;
use GekTools\Tools\BaseModel;
use CodeIgniter\Database\ConnectionInterface;
use CodeIgniter\Validation\ValidationInterface;

class LocalizedPropertiesModel extends BaseModel 
{

    #region fields

    protected $table = 'localized_properties';

    protected $returnType = LocalizedProperty::class;

    protected $primaryKey = 'id';

    protected $useSoftDeletes = false;

    protected $useTimestamps = false;

    protected $allowedFields = [
        'languageId',
        'entityId',
        'entityFullName',
        'fieldName',
        'value',
    ];

    protected $validationRules = [
        'languageId' => 'required|integer|greater_than_equal_to[0]',
        'entityId' => 'required|integer|greater_than_equal_to[0]',
        'entityFullName' => 'required|string|max_length[300]',
        'fieldName' => 'required|string|max_length[150]',
    ];

    #endregion fields

    #region ctor

    /**
     * 
     * @param ConnectionInterface $db
     * @param ValidationInterface $validation
     */ 
    public function __construct(ConnectionInterface &$db = null, ValidationInterface $validation = null){
        parent::__construct($db, $validation);
    }

    #endregion ctor

}
