<?php
namespace GekTools\Locale\Entities;

use GekTools\Tools\BaseEntity;
use GekTools\Tools\Contrats\ISystemName;
use GekTools\Tools\Contrats\IDisplayOrder;
use GekTools\Locale\Entities\Extensions\LanguageTrait;

class Language extends BaseEntity implements ISystemName, IDisplayOrder 
{

    use LanguageTrait;

    #region fields

    protected $attributes = [
        'id' => null,
        'name' => null,
        'systemName' => null,
        'culture' => null,
        'uniqueSeoCode' => null,
        'rtl' => 0,
        'currencyCode' => null,
        'displayOrder' => null,
        'published' => 0,
    ];

    protected $defaultValues = [
        'id' => 0,
        'name' => '',
        'systemName' => null,
        'culture' => '',
        'uniqueSeoCode' => '',
        'rtl' => 0,
        'currencyCode' => null,
        'displayOrder' => 0,
        'published' => 0,
    ];

    protected $datamap = [];

    protected $casts = [
        'id' => 'int',
        'name' => 'string',
        'systemName' => '?string',
        'culture' => 'string',
        'uniqueSeoCode' => 'string',
        'rtl' => 'bool',
        'currencyCode' => '?string',
        'displayOrder' => 'int',
        'published' => 'bool',
    ];

    #endregion fields

    #region properties

    /**
     * id getter

     * 
     * @return int|null
     * @throws \Exception
     */ 
    public function getId():?int {
        $_attrKey = $this->mapProperty('id');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'int');
        return $result;
    }

    /**
     * name getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getName():?string {
        $_attrKey = $this->mapProperty('name');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * name setter

     * 
     * @param string $name
     * @return self
     */ 
    public function setName(string $name):self {
        $_attrKey = $this->mapProperty('name');
        $this->attributes[$_attrKey] = $name;
        return $this;
    }

    /**
     * systemName getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getSystemName():?string {
        $_attrKey = $this->mapProperty('systemName');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?string');
        return $result;
    }

    /**
     * systemName setter

     * 
     * @param string|null $systemName
     * @return self
     */ 
    public function setSystemName(?string $systemName):self {
        $_attrKey = $this->mapProperty('systemName');
        $this->attributes[$_attrKey] = $systemName;
        return $this;
    }

    /**
     * culture getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getCulture():?string {
        $_attrKey = $this->mapProperty('culture');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * culture setter

     * 
     * @param string $culture
     * @return self
     */ 
    public function setCulture(string $culture):self {
        $_attrKey = $this->mapProperty('culture');
        $this->attributes[$_attrKey] = $culture;
        return $this;
    }

    /**
     * uniqueSeoCode getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getUniqueSeoCode():?string {
        $_attrKey = $this->mapProperty('uniqueSeoCode');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * uniqueSeoCode setter

     * 
     * @param string $uniqueSeoCode
     * @return self
     */ 
    public function setUniqueSeoCode(string $uniqueSeoCode):self {
        $_attrKey = $this->mapProperty('uniqueSeoCode');
        $this->attributes[$_attrKey] = $uniqueSeoCode;
        return $this;
    }

    /**
     * rtl getter

     * 
     * @return bool|null
     * @throws \Exception
     */ 
    public function getRtl():?bool {
        $_attrKey = $this->mapProperty('rtl');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'bool');
        return $result;
    }

    /**
     * rtl setter

     * 
     * @param bool $rtl
     * @return self
     */ 
    public function setRtl(bool $rtl):self {
        $_attrKey = $this->mapProperty('rtl');
        $this->attributes[$_attrKey] = $rtl;
        return $this;
    }

    /**
     * currencyCode getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getCurrencyCode():?string {
        $_attrKey = $this->mapProperty('currencyCode');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?string');
        return $result;
    }

    /**
     * currencyCode setter

     * 
     * @param string|null $currencyCode
     * @return self
     */ 
    public function setCurrencyCode(?string $currencyCode):self {
        $_attrKey = $this->mapProperty('currencyCode');
        $this->attributes[$_attrKey] = $currencyCode;
        return $this;
    }

    /**
     * displayOrder getter

     * 
     * @return int|null
     * @throws \Exception
     */ 
    public function getDisplayOrder():?int {
        $_attrKey = $this->mapProperty('displayOrder');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'int');
        return $result;
    }

    /**
     * displayOrder setter

     * 
     * @param int $displayOrder
     * @return self
     */ 
    public function setDisplayOrder(int $displayOrder):self {
        $_attrKey = $this->mapProperty('displayOrder');
        $this->attributes[$_attrKey] = $displayOrder;
        return $this;
    }

    /**
     * published getter

     * 
     * @return bool|null
     * @throws \Exception
     */ 
    public function getPublished():?bool {
        $_attrKey = $this->mapProperty('published');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'bool');
        return $result;
    }

    /**
     * published setter

     * 
     * @param bool $published
     * @return self
     */ 
    public function setPublished(bool $published):self {
        $_attrKey = $this->mapProperty('published');
        $this->attributes[$_attrKey] = $published;
        return $this;
    }

    #endregion properties

    #region statics

    /**
     * get db Fields info

     * 
     * @return LanguageFieldsInfo
     */ 
    public static function getFieldsInfo():LanguageFieldsInfo {
        static $fInfo = null;
        if($fInfo == null){
            $fInfo = new LanguageFieldsInfo();
        }
        return $fInfo;
    }

    #endregion statics

}


class LanguageFieldsInfo 
{

    /**
     * 
     * @var string
     */ 
    public string $id = 'id';

    /**
     * 
     * @var string
     */ 
    public string $name = 'name';

    /**
     * 
     * @var string
     */ 
    public string $systemName = 'systemName';

    /**
     * 
     * @var string
     */ 
    public string $culture = 'culture';

    /**
     * 
     * @var string
     */ 
    public string $uniqueSeoCode = 'uniqueSeoCode';

    /**
     * 
     * @var string
     */ 
    public string $rtl = 'rtl';

    /**
     * 
     * @var string
     */ 
    public string $currencyCode = 'currencyCode';

    /**
     * 
     * @var string
     */ 
    public string $displayOrder = 'displayOrder';

    /**
     * 
     * @var string
     */ 
    public string $published = 'published';

}
